/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ops.OperatorMetricRegistry;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.rest.profile.Comparators;
import org.apache.drill.exec.server.rest.profile.CoreOperatorType;
import org.apache.drill.exec.server.rest.profile.OperatorPathBuilder;
import org.apache.drill.exec.server.rest.profile.TableBuilder;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorWrapper {
    private static final Logger logger = LoggerFactory.getLogger(OperatorWrapper.class);
    private static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("#.##");
    private static final String UNKNOWN_OPERATOR = "UNKNOWN_OPERATOR";
    private static final int NO_SPILL_METRIC_INDEX = Integer.MIN_VALUE;
    private final int major;
    private final List<ImmutablePair<ImmutablePair<UserBitShared.OperatorProfile, Integer>, String>> opsAndHosts;
    private final UserBitShared.OperatorProfile firstProfile;
    private final String operatorType;
    private final String operatorName;
    private final int size;
    private final int timeSkewMin;
    private final double timeSkewRatio;
    private final int scanWaitMin;
    private final double waitSkewRatio;
    public static final String[] OPERATOR_COLUMNS = new String[]{"Minor Fragment", "Hostname", "Setup Time", "Process Time", "Wait Time", "Max Batches", "Max Records", "Peak Memory"};
    public static final String[] OPERATOR_COLUMNS_TOOLTIP = new String[]{"Operator's Minor Fragment", "Host on which the minor fragment ran", "Setup Time for the minor fragment's operator", "Process Time for the minor fragment's operator", "Wait Time for the minor fragment's operator", "Max Batches processed by the minor fragment's operator", "Max Records processed by the minor fragment's operator", "Peak Memory usage by the minor fragment's operator"};
    public static final String[] OPERATORS_OVERVIEW_COLUMNS = new String[]{"Operator ID", "Type", "Avg Setup Time", "Max Setup Time", "Avg Process Time", "Max Process Time", "Min Wait Time", "Avg Wait Time", "Max Wait Time", "% Fragment Time", "% Query Time", "Rows".concat("<div class='estRows' title='Estimated'>(Estimated)</div>"), "Avg Peak Memory", "Max Peak Memory"};
    public static final String[] OPERATORS_OVERVIEW_COLUMNS_TOOLTIP = new String[]{"Operator ID", "Operator Type", "Average time in setting up fragments", "Longest time a fragment took in setup", "Average process time for a fragment", "Longest process time of any fragment", "Shortest time a fragment spent in waiting", "Average wait time for a fragment", "Longest time a fragment spent in waiting", "Percentage of the total fragment time that was spent on the operator", "Percentage of the total query time that was spent on the operator", "Rows emitted by scans, or consumed by other operators", "Average memory consumption by a fragment", "Highest memory consumption by a fragment"};
    private static final String[] OPERATOR_OVERVIEW_BGCOLOR_PALETTE = new String[]{"#ffffff", "#f2f2f2"};

    public OperatorWrapper(int major, List<ImmutablePair<ImmutablePair<UserBitShared.OperatorProfile, Integer>, String>> opsAndHostsList, Map<String, String> phyOperMap, DrillConfig config) {
        CoreOperatorType operatorType;
        this.timeSkewMin = config.getInt("drill.exec.http.profile.warning.time.skew.min");
        this.timeSkewRatio = config.getDouble("drill.exec.http.profile.warning.time.skew.ratio.process");
        this.scanWaitMin = config.getInt("drill.exec.http.profile.warning.scan.wait.min");
        this.waitSkewRatio = config.getDouble("drill.exec.http.profile.warning.time.skew.ratio.wait");
        Preconditions.checkArgument(opsAndHostsList.size() > 0);
        this.major = major;
        this.firstProfile = (UserBitShared.OperatorProfile)((ImmutablePair)opsAndHostsList.get(0).getLeft()).getLeft();
        this.operatorType = this.firstProfile.hasOperatorTypeName() ? this.firstProfile.getOperatorTypeName() : ((operatorType = CoreOperatorType.valueOf(this.firstProfile.getOperatorType())) != null ? Objects.requireNonNull(operatorType).name() : null);
        String path = new OperatorPathBuilder().setMajor(major).setOperator(this.firstProfile).build();
        String extractedOpName = phyOperMap.get(path);
        String inferredOpName = this.operatorType == null ? UNKNOWN_OPERATOR : this.operatorType;
        this.operatorName = extractedOpName == null || inferredOpName.contains(extractedOpName) || extractedOpName.endsWith("_EXCHANGE") ? inferredOpName : extractedOpName;
        this.opsAndHosts = opsAndHostsList;
        this.size = opsAndHostsList.size();
    }

    public String getDisplayName() {
        String path = new OperatorPathBuilder().setMajor(this.major).setOperator(this.firstProfile).build();
        return String.format("%s - %s", path, this.operatorName);
    }

    public String getId() {
        return String.format("operator-%d-%d", this.major, ((UserBitShared.OperatorProfile)((ImmutablePair)this.opsAndHosts.get(0).getLeft()).getLeft()).getOperatorId());
    }

    public String getContent() {
        TableBuilder builder = new TableBuilder(OPERATOR_COLUMNS, OPERATOR_COLUMNS_TOOLTIP, true);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (ImmutablePair<ImmutablePair<UserBitShared.OperatorProfile, Integer>, String> ip : this.opsAndHosts) {
            int minor = (Integer)((ImmutablePair)ip.getLeft()).getRight();
            UserBitShared.OperatorProfile op = (UserBitShared.OperatorProfile)((ImmutablePair)ip.getLeft()).getLeft();
            attributeMap.put("data-order", String.valueOf(minor));
            String path = new OperatorPathBuilder().setMajor(this.major).setMinor(minor).setOperator(op).build();
            builder.appendCell(path, attributeMap);
            builder.appendCell((String)ip.getRight());
            builder.appendNanos(op.getSetupNanos());
            builder.appendNanos(op.getProcessNanos());
            builder.appendNanos(op.getWaitNanos());
            long maxBatches = Long.MIN_VALUE;
            long maxRecords = Long.MIN_VALUE;
            for (UserBitShared.StreamProfile sp : op.getInputProfileList()) {
                maxBatches = Math.max(sp.getBatches(), maxBatches);
                maxRecords = Math.max(sp.getRecords(), maxRecords);
            }
            builder.appendFormattedInteger(maxBatches);
            builder.appendFormattedInteger(maxRecords);
            builder.appendBytes(op.getPeakLocalMemoryAllocated());
        }
        return builder.build();
    }

    public void addSummary(TableBuilder tb, Map<String, Long> majorFragmentBusyTally, long majorFragmentBusyTallyTotal) {
        double maxSkew;
        String opTblBgColor = OPERATOR_OVERVIEW_BGCOLOR_PALETTE[this.major % OPERATOR_OVERVIEW_BGCOLOR_PALETTE.length];
        String path = new OperatorPathBuilder().setMajor(this.major).setOperator(this.firstProfile).build();
        tb.appendCell(path, opTblBgColor, null);
        tb.appendCell(this.operatorName);
        int spillCycleMetricIndex = this.getSpillCycleMetricIndex(this.operatorType);
        boolean isSpillableOp = spillCycleMetricIndex != Integer.MIN_VALUE;
        boolean hasSpilledToDisk = false;
        boolean isScanOp = this.operatorName.endsWith("SCAN");
        long majorBusyNanos = majorFragmentBusyTally.get(new OperatorPathBuilder().setMajor(this.major).build());
        double setupSum = 0.0;
        double processSum = 0.0;
        double waitSum = 0.0;
        double memSum = 0.0;
        double spillCycleSum = 0.0;
        long spillCycleMax = 0L;
        long recordSum = 0L;
        ArrayList<ImmutablePair> opList = new ArrayList<ImmutablePair>();
        for (ImmutablePair<ImmutablePair<UserBitShared.OperatorProfile, Integer>, String> ip : this.opsAndHosts) {
            UserBitShared.OperatorProfile profile = (UserBitShared.OperatorProfile)((ImmutablePair)ip.getLeft()).getLeft();
            setupSum += (double)profile.getSetupNanos();
            processSum += (double)profile.getProcessNanos();
            waitSum += (double)profile.getWaitNanos();
            memSum += (double)profile.getPeakLocalMemoryAllocated();
            for (UserBitShared.StreamProfile sp : profile.getInputProfileList()) {
                recordSum += sp.getRecords();
            }
            opList.add((ImmutablePair)ip.getLeft());
            if (!isSpillableOp) continue;
            for (UserBitShared.MetricValue metricVal : profile.getMetricList()) {
                if (metricVal.getMetricId() != spillCycleMetricIndex) continue;
                long spillCycles = metricVal.getLongValue();
                spillCycleMax = Math.max(spillCycles, spillCycleMax);
                hasSpilledToDisk = (spillCycleSum += (double)spillCycles) > 0.0;
            }
        }
        ImmutablePair longSetup = (ImmutablePair)Collections.max(opList, Comparators.setupTime);
        tb.appendNanos(Math.round(setupSum / (double)this.size));
        tb.appendNanos(((UserBitShared.OperatorProfile)longSetup.getLeft()).getSetupNanos());
        HashMap<String, String> timeSkewMap = null;
        ImmutablePair longProcess = (ImmutablePair)Collections.max(opList, Comparators.processTime);
        long avgProcTime = Math.round(processSum / (double)this.size);
        tb.appendNanos(avgProcTime);
        long maxProcTime = ((UserBitShared.OperatorProfile)longProcess.getLeft()).getProcessNanos();
        double d = maxSkew = avgProcTime > 0L ? (double)maxProcTime / (double)avgProcTime : 0.0;
        if (avgProcTime > TimeUnit.SECONDS.toNanos(this.timeSkewMin) && maxSkew > this.timeSkewRatio) {
            timeSkewMap = new HashMap<String, String>();
            timeSkewMap.put("class", "time-skew-tag");
            timeSkewMap.put("title", "One fragment took " + DECIMAL_FORMATTER.format(maxSkew) + " longer than average");
            timeSkewMap.put("style", "cursor:help;");
        }
        tb.appendNanos(maxProcTime, timeSkewMap);
        ImmutablePair shortWait = (ImmutablePair)Collections.min(opList, Comparators.waitTime);
        ImmutablePair longWait = (ImmutablePair)Collections.max(opList, Comparators.waitTime);
        tb.appendNanos(((UserBitShared.OperatorProfile)shortWait.getLeft()).getWaitNanos());
        long avgWaitTime = Math.round(waitSum / (double)this.size);
        HashMap<String, String> slowScanMap = null;
        if (isScanOp && avgWaitTime > TimeUnit.SECONDS.toNanos(this.scanWaitMin) && avgWaitTime > avgProcTime) {
            slowScanMap = new HashMap<String, String>();
            slowScanMap.put("class", "scan-wait-tag");
            slowScanMap.put("title", "Avg Wait Time &gt; Avg Processing Time");
            slowScanMap.put("style", "cursor:help;");
        }
        tb.appendNanos(avgWaitTime, slowScanMap);
        long maxWaitTime = ((UserBitShared.OperatorProfile)longWait.getLeft()).getWaitNanos();
        timeSkewMap = null;
        double d2 = maxSkew = avgWaitTime > 0L ? (double)maxWaitTime / (double)avgWaitTime : 0.0;
        if (avgWaitTime > TimeUnit.SECONDS.toNanos(this.timeSkewMin) && maxSkew > this.waitSkewRatio) {
            timeSkewMap = new HashMap();
            timeSkewMap.put("class", "time-skew-tag");
            timeSkewMap.put("title", "One fragment waited " + DECIMAL_FORMATTER.format(maxSkew) + " longer than average");
            timeSkewMap.put("style", "cursor:help;");
        }
        tb.appendNanos(maxWaitTime, timeSkewMap);
        tb.appendPercent(processSum / (double)majorBusyNanos);
        tb.appendPercent(processSum / (double)majorFragmentBusyTallyTotal);
        HashMap<String, String> estRowcountMap = new HashMap<String, String>();
        estRowcountMap.put("class", "estRowsAnchor");
        estRowcountMap.put("key", path.replaceAll("-xx-", "-"));
        tb.appendFormattedInteger(recordSum, estRowcountMap);
        ImmutablePair peakMem = (ImmutablePair)Collections.max(opList, Comparators.operatorPeakMemory);
        HashMap<String, String> avgSpillMap = null;
        HashMap<String, String> maxSpillMap = null;
        if (hasSpilledToDisk) {
            avgSpillMap = new HashMap<String, String>();
            double avgSpillCycle = spillCycleSum / (double)this.size;
            avgSpillMap.put("title", DECIMAL_FORMATTER.format(avgSpillCycle) + " spills on average");
            avgSpillMap.put("style", "cursor:help;");
            avgSpillMap.put("class", "spill-tag");
            avgSpillMap.put("spills", DECIMAL_FORMATTER.format(avgSpillCycle));
            maxSpillMap = new HashMap<String, String>();
            maxSpillMap.put("title", "Most # spills: " + spillCycleMax);
            maxSpillMap.put("style", "cursor:help;");
            maxSpillMap.put("class", "spill-tag");
            maxSpillMap.put("spills", String.valueOf(spillCycleMax));
        }
        tb.appendBytes(Math.round(memSum / (double)this.size), avgSpillMap);
        tb.appendBytes(((UserBitShared.OperatorProfile)peakMem.getLeft()).getPeakLocalMemoryAllocated(), maxSpillMap);
    }

    private int getSpillCycleMetricIndex(String operatorType) {
        String[] metricNames;
        String metricName;
        if (operatorType == null) {
            return Integer.MIN_VALUE;
        }
        switch (operatorType) {
            case "EXTERNAL_SORT": {
                metricName = "SPILL_COUNT";
                break;
            }
            case "HASH_AGGREGATE": 
            case "HASH_JOIN": {
                metricName = "SPILL_CYCLE";
                break;
            }
            default: {
                return Integer.MIN_VALUE;
            }
        }
        int metricIndex = 0;
        for (String name : metricNames = OperatorMetricRegistry.getMetricNames(operatorType)) {
            if (name.equalsIgnoreCase(metricName)) {
                return metricIndex;
            }
            ++metricIndex;
        }
        return Integer.MIN_VALUE;
    }

    public String getMetricsTable() {
        if (this.operatorType == null) {
            return "";
        }
        String[] metricNames = OperatorMetricRegistry.getMetricNames(this.operatorType);
        if (metricNames == null) {
            return "";
        }
        String[] metricsTableColumnNames = new String[metricNames.length + 1];
        metricsTableColumnNames[0] = "Minor Fragment";
        int i = 1;
        for (String metricName : metricNames) {
            metricsTableColumnNames[i++] = metricName;
        }
        TableBuilder builder = new TableBuilder(metricsTableColumnNames, null);
        for (ImmutablePair<ImmutablePair<UserBitShared.OperatorProfile, Integer>, String> ip : this.opsAndHosts) {
            UserBitShared.OperatorProfile op = (UserBitShared.OperatorProfile)((ImmutablePair)ip.getLeft()).getLeft();
            builder.appendCell(new OperatorPathBuilder().setMajor(this.major).setMinor((Integer)((ImmutablePair)ip.getLeft()).getRight()).setOperator(op).build());
            Number[] values = new Number[metricNames.length];
            for (UserBitShared.MetricValue metric : op.getMetricList()) {
                if (metric.getMetricId() >= metricNames.length) continue;
                if (metric.hasLongValue()) {
                    values[metric.getMetricId()] = metric.getLongValue();
                    continue;
                }
                if (!metric.hasDoubleValue()) continue;
                values[metric.getMetricId()] = metric.getDoubleValue();
            }
            for (Number value : values) {
                if (value != null) {
                    builder.appendFormattedNumber(value);
                    continue;
                }
                builder.appendCell("");
            }
        }
        return builder.build();
    }

    private class OperatorTblTxt {
        static final String MINOR_FRAGMENT = "Minor Fragment";
        static final String HOSTNAME = "Hostname";
        static final String SETUP_TIME = "Setup Time";
        static final String PROCESS_TIME = "Process Time";
        static final String WAIT_TIME = "Wait Time";
        static final String MAX_BATCHES = "Max Batches";
        static final String MAX_RECORDS = "Max Records";
        static final String PEAK_MEMORY = "Peak Memory";

        private OperatorTblTxt() {
        }
    }

    private class OperatorTblTooltip {
        static final String MINOR_FRAGMENT = "Operator's Minor Fragment";
        static final String HOSTNAME = "Host on which the minor fragment ran";
        static final String SETUP_TIME = "Setup Time for the minor fragment's operator";
        static final String PROCESS_TIME = "Process Time for the minor fragment's operator";
        static final String WAIT_TIME = "Wait Time for the minor fragment's operator";
        static final String MAX_BATCHES = "Max Batches processed by the minor fragment's operator";
        static final String MAX_RECORDS = "Max Records processed by the minor fragment's operator";
        static final String PEAK_MEMORY = "Peak Memory usage by the minor fragment's operator";

        private OperatorTblTooltip() {
        }
    }

    private class OverviewTblTxt {
        static final String OPERATOR_ID = "Operator ID";
        static final String TYPE_OF_OPERATOR = "Type";
        static final String AVG_SETUP_TIME = "Avg Setup Time";
        static final String MAX_SETUP_TIME = "Max Setup Time";
        static final String AVG_PROCESS_TIME = "Avg Process Time";
        static final String MAX_PROCESS_TIME = "Max Process Time";
        static final String MIN_WAIT_TIME = "Min Wait Time";
        static final String AVG_WAIT_TIME = "Avg Wait Time";
        static final String MAX_WAIT_TIME = "Max Wait Time";
        static final String PERCENT_FRAGMENT_TIME = "% Fragment Time";
        static final String PERCENT_QUERY_TIME = "% Query Time";
        static final String ROWS = "Rows";
        static final String ESTIMATED_ROWS = "<div class='estRows' title='Estimated'>(Estimated)</div>";
        static final String AVG_PEAK_MEMORY = "Avg Peak Memory";
        static final String MAX_PEAK_MEMORY = "Max Peak Memory";

        private OverviewTblTxt() {
        }
    }

    private class OverviewTblTooltip {
        static final String OPERATOR_ID = "Operator ID";
        static final String TYPE_OF_OPERATOR = "Operator Type";
        static final String AVG_SETUP_TIME = "Average time in setting up fragments";
        static final String MAX_SETUP_TIME = "Longest time a fragment took in setup";
        static final String AVG_PROCESS_TIME = "Average process time for a fragment";
        static final String MAX_PROCESS_TIME = "Longest process time of any fragment";
        static final String MIN_WAIT_TIME = "Shortest time a fragment spent in waiting";
        static final String AVG_WAIT_TIME = "Average wait time for a fragment";
        static final String MAX_WAIT_TIME = "Longest time a fragment spent in waiting";
        static final String PERCENT_FRAGMENT_TIME = "Percentage of the total fragment time that was spent on the operator";
        static final String PERCENT_QUERY_TIME = "Percentage of the total query time that was spent on the operator";
        static final String ROWS = "Rows emitted by scans, or consumed by other operators";
        static final String AVG_PEAK_MEMORY = "Average memory consumption by a fragment";
        static final String MAX_PEAK_MEMORY = "Highest memory consumption by a fragment";

        private OverviewTblTooltip() {
        }
    }
}

