/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import org.apache.drill.exec.proto.UserBitShared;

public class OperatorPathBuilder {
    private static final String OPERATOR_PATH_PATTERN = "%s-%s-%s";
    private static final String DEFAULT = "xx";
    private String major;
    private String minor;
    private String operator;

    public OperatorPathBuilder() {
        this.clear();
    }

    public void clear() {
        this.major = DEFAULT;
        this.minor = DEFAULT;
        this.operator = DEFAULT;
    }

    private String leftPad(String text) {
        int length = text.length();
        if (length > 2) {
            return text;
        }
        return String.format("00%s", text).substring(length);
    }

    public OperatorPathBuilder setMajor(UserBitShared.MajorFragmentProfile major) {
        if (major != null) {
            return this.setMajor(major.getMajorFragmentId());
        }
        return this;
    }

    public OperatorPathBuilder setMajor(int newMajor) {
        this.major = this.leftPad(String.valueOf(newMajor));
        return this;
    }

    public OperatorPathBuilder setMinor(UserBitShared.MinorFragmentProfile minor) {
        if (minor != null) {
            return this.setMinor(minor.getMinorFragmentId());
        }
        return this;
    }

    public OperatorPathBuilder setMinor(int newMinor) {
        this.minor = this.leftPad(String.valueOf(newMinor));
        return this;
    }

    public OperatorPathBuilder setOperator(UserBitShared.OperatorProfile op) {
        if (op != null) {
            return this.setOperator(op.getOperatorId());
        }
        return this;
    }

    public OperatorPathBuilder setOperator(int newOp) {
        this.operator = this.leftPad(String.valueOf(newOp));
        return this;
    }

    public String build() {
        StringBuffer sb = new StringBuffer();
        return sb.append(this.major).append("-").append(this.minor).append("-").append(this.operator).toString();
    }
}

