/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.profile;

import java.util.Arrays;

public enum CoreOperatorType {
    SINGLE_SENDER(0),
    BROADCAST_SENDER(1),
    FILTER(2),
    HASH_AGGREGATE(3),
    HASH_JOIN(4),
    MERGE_JOIN(5),
    HASH_PARTITION_SENDER(6),
    LIMIT(7),
    MERGING_RECEIVER(8),
    ORDERED_PARTITION_SENDER(9),
    PROJECT(10),
    UNORDERED_RECEIVER(11),
    RANGE_PARTITION_SENDER(12),
    SCREEN(13),
    SELECTION_VECTOR_REMOVER(14),
    STREAMING_AGGREGATE(15),
    TOP_N_SORT(16),
    EXTERNAL_SORT(17),
    TRACE(18),
    UNION(19),
    OLD_SORT(20),
    PARQUET_ROW_GROUP_SCAN(21),
    HIVE_SUB_SCAN(22),
    SYSTEM_TABLE_SCAN(23),
    MOCK_SUB_SCAN(24),
    PARQUET_WRITER(25),
    DIRECT_SUB_SCAN(26),
    TEXT_WRITER(27),
    TEXT_SUB_SCAN(28),
    JSON_SUB_SCAN(29),
    INFO_SCHEMA_SUB_SCAN(30),
    COMPLEX_TO_JSON(31),
    PRODUCER_CONSUMER(32),
    HBASE_SUB_SCAN(33),
    WINDOW(34),
    NESTED_LOOP_JOIN(35),
    AVRO_SUB_SCAN(36),
    PCAP_SUB_SCAN(37),
    KAFKA_SUB_SCAN(38),
    KUDU_SUB_SCAN(39),
    FLATTEN(40),
    LATERAL_JOIN(41),
    UNNEST(42),
    HIVE_DRILL_NATIVE_PARQUET_ROW_GROUP_SCAN(43),
    JDBC_SCAN(44),
    REGEX_SUB_SCAN(45),
    MAPRDB_SUB_SCAN(46),
    MONGO_SUB_SCAN(47),
    KUDU_WRITER(48),
    OPEN_TSDB_SUB_SCAN(49),
    JSON_WRITER(50),
    HTPPD_LOG_SUB_SCAN(51),
    IMAGE_SUB_SCAN(52),
    SEQUENCE_SUB_SCAN(53),
    PARTITION_LIMIT(54),
    PCAPNG_SUB_SCAN(55),
    RUNTIME_FILTER(56),
    ROWKEY_JOIN(57),
    SYSLOG_SUB_SCAN(58),
    STATISTICS_AGGREGATE(59),
    UNPIVOT_MAPS(60),
    STATISTICS_MERGE(61),
    LTSV_SUB_SCAN(62),
    HDF5_SUB_SCAN(63),
    EXCEL_SUB_SCAN(64),
    SHP_SUB_SCAN(65),
    METADATA_HANDLER(66),
    METADATA_CONTROLLER(67),
    DRUID_SUB_SCAN(68),
    SPSS_SUB_SCAN(69),
    HTTP_SUB_SCAN(70),
    XML_SUB_SCAN(71);

    private final int value;

    private CoreOperatorType(int value) {
        this.value = value;
    }

    public int getId() {
        return this.value;
    }

    public static CoreOperatorType valueOf(int id) {
        if (id >= 0 && id <= XML_SUB_SCAN.getId()) {
            return CoreOperatorType.values()[id];
        }
        return null;
    }

    public static CoreOperatorType forName(String name) {
        return Arrays.stream(CoreOperatorType.values()).filter(value -> value.name().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

