/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.header;

import com.typesafe.config.ConfigObject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.drill.common.config.DrillConfig;

public class ResponseHeadersSettingFilter
implements Filter {
    private Map<String, String> responseHeaders;

    public static Map<String, String> retrieveResponseHeaders(DrillConfig config) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (config.hasPath("drill.exec.http.jetty.server.response.headers")) {
            ConfigObject headersConf = config.getObject("drill.exec.http.jetty.server.response.headers");
            Iterator iterator = headersConf.keySet().iterator();
            while (iterator.hasNext()) {
                String header;
                Object val = headersConf.get((Object)(header = (String)iterator.next())).unwrapped();
                headers.put(header, val == null ? null : val.toString());
            }
        }
        return headers;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.responseHeaders = new HashMap<String, String>();
        Enumeration headers = filterConfig.getInitParameterNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            String value = filterConfig.getInitParameter(header);
            this.responseHeaders.put(header, value);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.responseHeaders.forEach((arg_0, arg_1) -> ((HttpServletResponse)((HttpServletResponse)response)).setHeader(arg_0, arg_1));
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.responseHeaders = null;
    }
}

