/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class SpnegoConfig {
    public static final String GSS_SPNEGO_MECH_OID = "1.3.6.1.5.5.2";
    private UserGroupInformation loggedInUgi;
    private final String principal;
    private final String keytab;
    private final String clientNameMapping;

    public SpnegoConfig(DrillConfig config) {
        this.keytab = config.hasPath("drill.exec.http.auth.spnego.keytab") ? config.getString("drill.exec.http.auth.spnego.keytab") : null;
        this.principal = config.hasPath("drill.exec.http.auth.spnego.principal") ? config.getString("drill.exec.http.auth.spnego.principal") : null;
        this.clientNameMapping = config.hasPath("drill.exec.security.auth.auth_to_local") ? config.getString("drill.exec.security.auth.auth_to_local") : null;
    }

    public String getSpnegoPrincipal() {
        return this.principal;
    }

    public void validateSpnegoConfig() throws DrillException {
        StringBuilder errorMsg = new StringBuilder();
        if (this.principal != null && this.keytab != null) {
            return;
        }
        if (this.principal == null) {
            errorMsg.append("\nConfiguration ");
            errorMsg.append("drill.exec.http.auth.spnego.principal");
            errorMsg.append(" is not found");
        }
        if (this.keytab == null) {
            errorMsg.append("\nConfiguration ");
            errorMsg.append("drill.exec.http.auth.spnego.keytab");
            errorMsg.append(" is not found");
        }
        throw new DrillException(errorMsg.toString());
    }

    public UserGroupInformation getLoggedInUgi() throws DrillException {
        if (this.loggedInUgi != null) {
            return this.loggedInUgi;
        }
        this.loggedInUgi = this.loginAndReturnUgi();
        return this.loggedInUgi;
    }

    private UserGroupInformation loginAndReturnUgi() throws DrillException {
        UserGroupInformation ugi;
        this.validateSpnegoConfig();
        try {
            if (!UserGroupInformation.isSecurityEnabled()) {
                Configuration newConfig = new Configuration();
                newConfig.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
                if (this.clientNameMapping != null) {
                    newConfig.set("hadoop.security.auth_to_local", this.clientNameMapping);
                }
                UserGroupInformation.setConfiguration((Configuration)newConfig);
                ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytab);
                UserGroupInformation.setConfiguration((Configuration)new Configuration());
            } else {
                ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this.principal, (String)this.keytab);
            }
        }
        catch (Exception e) {
            throw new DrillException(String.format("Login failed for %s with given keytab", this.principal), e);
        }
        return ugi;
    }
}

