/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.parquet.Strings;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSpnegoAuthenticator
extends SpnegoAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(DrillSpnegoAuthenticator.class);

    public DrillSpnegoAuthenticator(String authMethod) {
        super(authMethod);
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatoryAuth) throws ServerAuthException {
        boolean mandatory;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpSession session = req.getSession(true);
        Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        String uri = req.getRequestURI();
        boolean bl = mandatory = mandatoryAuth || uri.equals("/spnegoLogin");
        if (authentication != null) {
            if (uri.equals("/logout")) {
                return null;
            }
            return authentication;
        }
        return this.authenticateSession(request, response, mandatory);
    }

    private Authentication authenticateSession(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        HttpSession session = req.getSession(true);
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        String header = req.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (header == null) {
            try {
                if (DeferredAuthentication.isDeferred((HttpServletResponse)res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                res.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), HttpHeader.NEGOTIATE.asString());
                res.sendError(401);
                logger.debug("DrillSpnegoAuthenticator: Sending challenge to client {}", (Object)req.getRemoteAddr());
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException e) {
                logger.error("DrillSpnegoAuthenticator: Failed while sending challenge to client {}", (Object)req.getRemoteAddr(), (Object)e);
                throw new ServerAuthException((Throwable)e);
            }
        }
        logger.debug("DrillSpnegoAuthenticator: Received NEGOTIATE Response back from client {}", (Object)req.getRemoteAddr());
        String negotiateString = HttpHeader.NEGOTIATE.asString();
        if (header.startsWith(negotiateString) && (user = this.login(null, spnegoToken = header.substring(negotiateString.length() + 1), request)) != null) {
            String newUri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
            if (Strings.isNullOrEmpty((String)newUri) && Strings.isNullOrEmpty((String)(newUri = req.getContextPath()))) {
                newUri = "/";
            }
            response.setContentLength(0);
            Request baseRequest = Request.getBaseRequest((ServletRequest)req);
            int redirectCode = baseRequest.getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303;
            try {
                baseRequest.getResponse().sendRedirect(redirectCode, res.encodeRedirectURL(newUri));
            }
            catch (IOException e) {
                logger.error("DrillSpnegoAuthenticator: Failed while using the redirect URL {} from client {}", new Object[]{newUri, req.getRemoteAddr(), e});
                throw new ServerAuthException((Throwable)e);
            }
            logger.debug("DrillSpnegoAuthenticator: Successfully authenticated this client session: {}", (Object)user.getUserPrincipal().getName());
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        logger.debug("DrillSpnegoAuthenticator: Authentication failed for client session: {}", (Object)req.getRemoteAddr());
        return Authentication.UNAUTHENTICATED;
    }

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
        }
        return user;
    }
}

