/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.rpc.security.AuthenticatorFactory;
import org.apache.drill.exec.rpc.security.plain.PlainFactory;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.auth.DrillUserPrincipal;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRestLoginService
implements LoginService {
    private static final Logger logger = LoggerFactory.getLogger(DrillRestLoginService.class);
    private final DrillbitContext drillbitContext;
    private IdentityService identityService = new DefaultIdentityService();

    public DrillRestLoginService(DrillbitContext drillbitContext) {
        this.drillbitContext = drillbitContext;
    }

    public boolean validate(UserIdentity user) {
        return true;
    }

    public String getName() {
        return "DrillRestLoginService";
    }

    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (!(credentials instanceof String)) {
            return null;
        }
        try {
            AuthenticatorFactory plainFactory = this.drillbitContext.getAuthProvider().getAuthenticatorFactory("PLAIN");
            UserAuthenticator userAuthenticator = ((PlainFactory)plainFactory).getAuthenticator();
            userAuthenticator.authenticate(username, credentials.toString());
            logger.info("WebUser {} logged in from {}:{}", new Object[]{username, request.getRemoteHost(), request.getRemotePort()});
            SystemOptionManager sysOptions = this.drillbitContext.getOptionManager();
            boolean isAdmin = ImpersonationUtil.hasAdminPrivileges(username, ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(sysOptions), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(sysOptions));
            DrillUserPrincipal userPrincipal = new DrillUserPrincipal(username, isAdmin);
            Subject subject = new Subject();
            subject.getPrincipals().add(userPrincipal);
            subject.getPrivateCredentials().add(credentials);
            if (isAdmin) {
                subject.getPrincipals().addAll(DrillUserPrincipal.ADMIN_PRINCIPALS);
                return this.identityService.newUserIdentity(subject, (Principal)userPrincipal, DrillUserPrincipal.ADMIN_USER_ROLES);
            }
            subject.getPrincipals().addAll(DrillUserPrincipal.NON_ADMIN_PRINCIPALS);
            return this.identityService.newUserIdentity(subject, (Principal)userPrincipal, DrillUserPrincipal.NON_ADMIN_USER_ROLES);
        }
        catch (Exception e) {
            if (e instanceof UserAuthenticationException) {
                logger.debug("Authentication failed for WebUser '{}'", (Object)username, (Object)e);
            } else {
                logger.error("Unexpected failure occurred for WebUser {} during login.", (Object)username, (Object)e);
            }
            return null;
        }
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void logout(UserIdentity user) {
        if (logger.isTraceEnabled()) {
            logger.trace("Web user {} logged out.", (Object)user.getUserPrincipal().getName());
        }
    }
}

