/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.util.Collections;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;

public abstract class DrillHttpConstraintSecurityHandler
extends ConstraintSecurityHandler {
    public void doStart() throws Exception {
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
    }

    public abstract void doSetup(DrillbitContext var1) throws DrillException;

    public void setup(LoginAuthenticator authenticator, LoginService loginService) {
        ImmutableSet<String> knownRoles = ImmutableSet.of("authenticated", "admin");
        this.setConstraintMappings(Collections.emptyList(), knownRoles);
        this.setAuthenticator((Authenticator)authenticator);
        this.setLoginService(loginService);
    }

    protected void requireAuthProvider(DrillbitContext dbContext, String name) throws DrillException {
        if (!dbContext.getAuthProvider().containsFactory("PLAIN")) {
            throw new DrillException(String.format("%1$s auth mechanism was configured but %2$s mechanism is not enabled to provide an authenticator. Please configure user authentication with %2$s mechanism and authenticator to use %1$s authentication", this.getImplName(), name));
        }
    }

    public abstract String getImplName();
}

