/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest.auth;

import java.net.URI;
import java.net.URLEncoder;
import javax.annotation.Priority;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDynamicFeature
implements DynamicFeature {
    private static final Logger logger = LoggerFactory.getLogger(AuthDynamicFeature.class);

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        RolesAllowed ra = (RolesAllowed)am.getAnnotation(RolesAllowed.class);
        if (ra != null) {
            configuration.register((Object)AuthCheckFilter.INSTANCE);
            return;
        }
        if (am.isAnnotationPresent(PermitAll.class)) {
            return;
        }
        ra = resourceInfo.getResourceClass().getAnnotation(RolesAllowed.class);
        if (ra != null) {
            configuration.register((Object)AuthCheckFilter.INSTANCE);
        }
    }

    public static boolean isUserLoggedIn(SecurityContext sc) {
        return sc != null && sc.getUserPrincipal() != null;
    }

    @Priority(value=1000)
    private static class AuthCheckFilter
    implements ContainerRequestFilter {
        private static AuthCheckFilter INSTANCE = new AuthCheckFilter();

        private AuthCheckFilter() {
        }

        public void filter(ContainerRequestContext requestContext) {
            SecurityContext sc = requestContext.getSecurityContext();
            if (!AuthDynamicFeature.isUserLoggedIn(sc)) {
                try {
                    String destResource = URLEncoder.encode(requestContext.getUriInfo().getRequestUri().getPath(), "UTF-8");
                    URI loginURI = requestContext.getUriInfo().getBaseUriBuilder().path("mainLogin").queryParam("redirect", new Object[]{destResource}).build(new Object[0]);
                    requestContext.abortWith(Response.temporaryRedirect((URI)loginURI).build());
                }
                catch (Exception ex) {
                    String errMsg = String.format("Failed to forward the request to login page: %s", ex.getMessage());
                    logger.error(errMsg, (Throwable)ex);
                    requestContext.abortWith(Response.serverError().entity((Object)errMsg).build());
                }
            }
        }
    }
}

