/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.materialize.QueryDataPackage;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.server.rest.BaseWebUserConnection;
import org.apache.drill.exec.server.rest.WebSessionResources;
import org.apache.drill.exec.util.ValueVectorElementFormatter;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class WebUserConnection
extends BaseWebUserConnection {
    public final List<Map<String, String>> results = Lists.newArrayList();
    public final Set<String> columns = Sets.newLinkedHashSet();
    public final List<String> metadata = new ArrayList<String>();
    private int autoLimitRowCount;
    private int rowCount;

    WebUserConnection(WebSessionResources webSessionResources) {
        super(webSessionResources);
    }

    @Override
    public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryDataPackage data) {
        this.processBatch(data.batch());
        listener.success(Acks.OK, null);
    }

    private void processBatch(VectorContainer batch) {
        if (batch == null) {
            return;
        }
        if (this.metadata.isEmpty() || batch.isSchemaChanged()) {
            this.columns.clear();
            this.metadata.clear();
            this.buildMetadata(batch.getSchema());
        }
        this.addResults(batch.getRecordCount(), batch);
        batch.zeroVectors();
    }

    private void buildMetadata(BatchSchema schema) {
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            MaterializedField col = schema.getColumn(i);
            this.columns.add(col.getName());
            this.metadata.add(this.webDataType(col.getType()));
        }
    }

    private void addResults(int rows, VectorAccessible batch) {
        ValueVectorElementFormatter formatter = new ValueVectorElementFormatter(this.webSessionResources.getSession().getOptions());
        if (this.autoLimitRowCount > 0) {
            rows = Math.max(0, Math.min(rows, this.autoLimitRowCount - this.rowCount));
        }
        for (int i = 0; i < rows; ++i) {
            ++this.rowCount;
            HashMap<String, String> record = Maps.newHashMap();
            for (VectorWrapper vw : batch) {
                String field = vw.getValueVector().getMetadata().getNamePart().getName();
                TypeProtos.MinorType fieldMinorType = vw.getValueVector().getMetadata().getMajorType().getMinorType();
                ValueVector.Accessor accessor = vw.getValueVector().getAccessor();
                Object value = i < accessor.getValueCount() ? accessor.getObject(i) : null;
                String display = value == null ? null : formatter.format(value, fieldMinorType);
                record.put(field, display);
            }
            this.results.add(record);
        }
    }

    public void cleanupSession() {
    }

    void setAutoLimitRowCount(int autoLimitRowCount) {
        this.autoLimitRowCount = autoLimitRowCount;
    }

    public int getAutoLimitRowCount() {
        return this.autoLimitRowCount;
    }

    public static class AnonWebUserConnection
    extends WebUserConnection {
        AnonWebUserConnection(WebSessionResources webSessionResources) {
            super(webSessionResources);
        }

        @Override
        public void cleanupSession() {
            this.webSessionResources.close();
        }
    }
}

