/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlets.MetricsServlet;
import com.codahale.metrics.servlets.ThreadDumpServlet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillException;
import org.apache.drill.common.util.DrillFileUtils;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.expr.fn.registry.FunctionHolder;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.CsrfTokenInjectFilter;
import org.apache.drill.exec.server.rest.CsrfTokenValidateFilter;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.WebSessionResources;
import org.apache.drill.exec.server.rest.auth.DrillErrorHandler;
import org.apache.drill.exec.server.rest.auth.DrillHttpSecurityHandlerProvider;
import org.apache.drill.exec.server.rest.header.ResponseHeadersSettingFilter;
import org.apache.drill.exec.server.rest.ssl.SslContextFactoryConfigurator;
import org.apache.drill.exec.work.WorkManager;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WebServer.class);
    private static final String ACE_MODE_SQL_TEMPLATE_JS = "ace.mode-sql.template.js";
    private static final String ACE_MODE_SQL_JS = "mode-sql.js";
    private static final String DRILL_FUNCTIONS_PLACEHOLDER = "__DRILL_FUNCTIONS__";
    private static final String STATUS_THREADS_PATH = "/status/threads";
    private static final String STATUS_METRICS_PATH = "/status/metrics";
    private static final String OPTIONS_DESCRIBE_JS = "options.describe.js";
    private static final String OPTIONS_DESCRIBE_TEMPLATE_JS = "options.describe.template.js";
    private static final int PORT_HUNT_TRIES = 100;
    private static final String BASE_STATIC_PATH = "/rest/static/";
    private static final String DRILL_ICON_RESOURCE_RELATIVE_PATH = "img/drill.ico";
    private final DrillConfig config;
    private final MetricRegistry metrics;
    private final WorkManager workManager;
    private final Drillbit drillbit;
    private Server embeddedJetty;
    private File tmpJavaScriptDir;

    public WebServer(BootStrapContext context, WorkManager workManager, Drillbit drillbit) {
        this.config = context.getConfig();
        this.metrics = context.getMetrics();
        this.workManager = workManager;
        this.drillbit = drillbit;
    }

    public static boolean isOnlyImpersonationEnabled(DrillConfig config) {
        return !config.getBoolean("drill.exec.security.user.auth.enabled") && config.getBoolean("drill.exec.impersonation.enabled");
    }

    public void start() throws Exception {
        if (!this.config.getBoolean("drill.exec.http.enabled")) {
            return;
        }
        QueuedThreadPool threadPool = new QueuedThreadPool(2, 2);
        this.embeddedJetty = new Server((ThreadPool)threadPool);
        boolean authEnabled = this.config.getBoolean("drill.exec.security.user.auth.enabled");
        ServletContextHandler webServerContext = this.createServletContextHandler(authEnabled);
        this.embeddedJetty.setHandler((Handler)webServerContext);
        int acceptors = this.config.getInt("drill.exec.http.jetty.server.acceptors");
        int selectors = this.config.getInt("drill.exec.http.jetty.server.selectors");
        String bindAddr = this.config.getString("drill.exec.http.bind_addr");
        int port = this.config.getInt("drill.exec.http.port");
        ServerConnector connector = this.createConnector(bindAddr, port, acceptors, selectors);
        int handlers = this.config.getInt("drill.exec.http.jetty.server.handlers");
        threadPool.setMaxThreads(handlers + connector.getAcceptors() + connector.getSelectorManager().getSelectorCount());
        this.embeddedJetty.addConnector((Connector)connector);
        this.embeddedJetty.setDumpAfterStart(this.config.getBoolean("drill.exec.http.jetty.server.dumpAfterStart"));
        boolean portHunt = this.config.getBoolean("drill.exec.http.porthunt");
        for (int retry = 0; retry < 100; ++retry) {
            connector.setPort(port);
            try {
                this.embeddedJetty.start();
                return;
            }
            catch (IOException e) {
                if (!portHunt) {
                    throw e;
                }
                logger.info("Failed to start on port {}, trying port {}", new Object[]{port, ++port, e});
                continue;
            }
        }
        throw new IOException("Failed to find a port");
    }

    private ServletContextHandler createServletContextHandler(boolean authEnabled) throws DrillbitStartupException {
        DrillErrorHandler errorHandler = new DrillErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setShowMessageInTitle(true);
        ServletContextHandler servletContextHandler = new ServletContextHandler(1);
        servletContextHandler.setErrorHandler((ErrorHandler)errorHandler);
        servletContextHandler.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new DrillRestServer(this.workManager, (ServletContext)servletContextHandler.getServletContext(), this.drillbit)));
        servletHolder.setInitOrder(1);
        servletContextHandler.addServlet(servletHolder, "/*");
        servletContextHandler.addServlet(new ServletHolder((Servlet)new MetricsServlet(this.metrics)), STATUS_METRICS_PATH);
        servletContextHandler.addServlet(new ServletHolder((Servlet)new ThreadDumpServlet()), STATUS_THREADS_PATH);
        ServletHolder staticHolder = new ServletHolder("static", DefaultServlet.class);
        String drillIconResourcePath = Resource.newClassPathResource((String)"/rest/static/img/drill.ico").getURI().toString();
        staticHolder.setInitParameter("resourceBase", drillIconResourcePath.substring(0, drillIconResourcePath.length() - DRILL_ICON_RESOURCE_RELATIVE_PATH.length()));
        staticHolder.setInitParameter("dirAllowed", "false");
        staticHolder.setInitParameter("pathInfoOnly", "true");
        servletContextHandler.addServlet(staticHolder, "/static/*");
        ServletHolder dynamicHolder = new ServletHolder("dynamic", DefaultServlet.class);
        if (this.getOrCreateTmpJavaScriptDir() != null) {
            dynamicHolder.setInitParameter("resourceBase", this.getOrCreateTmpJavaScriptDir().getAbsolutePath());
            dynamicHolder.setInitParameter("dirAllowed", "true");
            dynamicHolder.setInitParameter("pathInfoOnly", "true");
            servletContextHandler.addServlet(dynamicHolder, "/dynamic/*");
        }
        if (authEnabled) {
            servletContextHandler.setSecurityHandler((SecurityHandler)new DrillHttpSecurityHandlerProvider(this.config, this.workManager.getContext()));
            servletContextHandler.setSessionHandler(this.createSessionHandler(servletContextHandler.getSecurityHandler()));
        }
        servletContextHandler.addFilter(CsrfTokenInjectFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        for (String path : new String[]{"/query", "/storage/create_update", "/option/*"}) {
            servletContextHandler.addFilter(CsrfTokenValidateFilter.class, path, EnumSet.of(DispatcherType.REQUEST));
        }
        if (this.config.getBoolean("drill.exec.http.cors.enabled")) {
            FilterHolder holder = new FilterHolder(CrossOriginFilter.class);
            holder.setInitParameter("allowedOrigins", StringUtils.join((Iterable)this.config.getStringList("drill.exec.http.cors.allowedOrigins"), (String)","));
            holder.setInitParameter("allowedMethods", StringUtils.join((Iterable)this.config.getStringList("drill.exec.http.cors.allowedMethods"), (String)","));
            holder.setInitParameter("allowedHeaders", StringUtils.join((Iterable)this.config.getStringList("drill.exec.http.cors.allowedHeaders"), (String)","));
            holder.setInitParameter("allowCredentials", String.valueOf(this.config.getBoolean("drill.exec.http.cors.credentials")));
            for (String path : new String[]{"*.json", "/storage/*/enable/*", "/status*"}) {
                servletContextHandler.addFilter(holder, path, EnumSet.of(DispatcherType.REQUEST));
            }
        }
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameter("allowedOrigins", "*");
        servletContextHandler.addFilter(filterHolder, STATUS_METRICS_PATH, null);
        FilterHolder responseHeadersSettingFilter = new FilterHolder(ResponseHeadersSettingFilter.class);
        responseHeadersSettingFilter.setInitParameters(ResponseHeadersSettingFilter.retrieveResponseHeaders(this.config));
        servletContextHandler.addFilter(responseHeadersSettingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        return servletContextHandler;
    }

    private SessionHandler createSessionHandler(final SecurityHandler securityHandler) {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setMaxInactiveInterval(this.config.getInt("drill.exec.http.session_max_idle_secs"));
        sessionHandler.getSessionCookieConfig().setHttpOnly(true);
        sessionHandler.addEventListener((EventListener)new HttpSessionListener(){

            public void sessionCreated(HttpSessionEvent se) {
            }

            public void sessionDestroyed(HttpSessionEvent se) {
                WebSessionResources webSessionResources;
                HttpSession session = se.getSession();
                if (session == null) {
                    return;
                }
                Object authCreds = session.getAttribute("org.eclipse.jetty.security.UserIdentity");
                if (authCreds != null) {
                    SessionAuthentication sessionAuth = (SessionAuthentication)authCreds;
                    securityHandler.logout((Authentication.User)sessionAuth);
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                }
                if ((webSessionResources = (WebSessionResources)session.getAttribute(WebSessionResources.class.getSimpleName())) != null) {
                    webSessionResources.close();
                    session.removeAttribute(WebSessionResources.class.getSimpleName());
                }
            }
        });
        return sessionHandler;
    }

    public int getPort() {
        if (!this.isRunning()) {
            throw new UnsupportedOperationException("HTTP server is not enabled");
        }
        return ((ServerConnector)this.embeddedJetty.getConnectors()[0]).getPort();
    }

    public boolean isRunning() {
        return this.embeddedJetty != null && this.embeddedJetty.getConnectors().length == 1;
    }

    private ServerConnector createConnector(String bindAddr, int port, int acceptors, int selectors) throws Exception {
        ServerConnector serverConnector;
        if (this.config.getBoolean("drill.exec.http.ssl_enabled")) {
            try {
                serverConnector = this.createHttpsConnector(bindAddr, port, acceptors, selectors);
            }
            catch (DrillException e) {
                throw new DrillbitStartupException(e.getMessage(), e);
            }
        } else {
            serverConnector = this.createHttpConnector(bindAddr, port, acceptors, selectors);
        }
        return serverConnector;
    }

    private ServerConnector createHttpsConnector(String bindAddr, int port, int acceptors, int selectors) throws Exception {
        logger.info("Setting up HTTPS connector for web server at {}:{}", (Object)bindAddr, (Object)port);
        SslContextFactory.Server sslContextFactory = new SslContextFactoryConfigurator(this.config, this.workManager.getContext().getEndpoint().getAddress()).configureNewSslContextFactory();
        HttpConfiguration httpsConfig = this.baseHttpConfig();
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(this.embeddedJetty, null, null, null, acceptors, selectors, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        sslConnector.setHost(bindAddr);
        sslConnector.setPort(port);
        return sslConnector;
    }

    private ServerConnector createHttpConnector(String bindAddr, int port, int acceptors, int selectors) {
        logger.info("Setting up HTTP connector for web server at {}:{}", (Object)bindAddr, (Object)port);
        ServerConnector httpConnector = new ServerConnector(this.embeddedJetty, null, null, null, acceptors, selectors, new ConnectionFactory[]{new HttpConnectionFactory(this.baseHttpConfig())});
        httpConnector.setHost(bindAddr);
        httpConnector.setPort(port);
        return httpConnector;
    }

    private HttpConfiguration baseHttpConfig() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        return httpConfig;
    }

    @Override
    public void close() throws Exception {
        if (this.embeddedJetty != null) {
            this.embeddedJetty.stop();
        }
        FileUtils.deleteQuietly((File)this.tmpJavaScriptDir);
    }

    public File getOrCreateTmpJavaScriptDir() {
        if (this.tmpJavaScriptDir == null && this.drillbit.getContext() != null) {
            this.tmpJavaScriptDir = DrillFileUtils.createTempDir();
            try {
                this.generateOptionsDescriptionJSFile();
                this.generateFunctionJS();
            }
            catch (IOException e) {
                logger.error("Unable to create temp dir for JavaScripts: {}", (Object)this.tmpJavaScriptDir.getPath(), (Object)e);
            }
        }
        return this.tmpJavaScriptDir;
    }

    private void generateOptionsDescriptionJSFile() throws IOException {
        SystemOptionManager optionManager = this.drillbit.getContext().getOptionManager();
        OptionList publicOptions = optionManager.getPublicOptionList();
        ArrayList<OptionValue> options = new ArrayList<OptionValue>(publicOptions);
        OptionList internalOptions = optionManager.getInternalOptionList();
        options.addAll(internalOptions);
        Collections.sort(options);
        int numLeftToWrite = options.size();
        InputStream optionsDescribeTemplateStream = Resource.newClassPathResource((String)OPTIONS_DESCRIBE_TEMPLATE_JS).getInputStream();
        File optionsDescriptionFile = new File(this.getOrCreateTmpJavaScriptDir(), OPTIONS_DESCRIBE_JS);
        String file_content_footer = "};";
        Files.copy(optionsDescribeTemplateStream, optionsDescriptionFile.toPath(), new CopyOption[0]);
        logger.info("Will write {} descriptions to {}", (Object)numLeftToWrite, (Object)optionsDescriptionFile.getAbsolutePath());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(optionsDescriptionFile, true));){
            for (OptionValue option : options) {
                --numLeftToWrite;
                String optionName = option.getName();
                OptionValidator.OptionDescription optionDescription = optionManager.getOptionDefinition(optionName).getValidator().getOptionDescription();
                if (optionDescription == null) continue;
                writer.append("  \"").append(optionName).append("\" : \"").append(StringEscapeUtils.escapeEcmaScript((String)optionDescription.getDescription())).append(numLeftToWrite > 0 ? "\"," : "\"");
                writer.newLine();
            }
            writer.append("};");
            writer.newLine();
            writer.flush();
        }
    }

    private void generateFunctionJS() throws IOException {
        TreeSet<String> functionSet = new TreeSet<String>();
        List<FunctionHolder> builtInFuncHolderList = this.drillbit.getContext().getFunctionImplementationRegistry().getLocalFunctionRegistry().getAllJarsWithFunctionsHolders().get("built-in");
        int skipCount = 0;
        for (FunctionHolder builtInFunctionHolder : builtInFuncHolderList) {
            String name = builtInFunctionHolder.getName();
            if (!name.contains(" ") && name.matches("([a-z]|[A-Z])\\w+") && !builtInFunctionHolder.getHolder().isInternal()) {
                functionSet.add(name);
                continue;
            }
            logger.debug("Non-alphabetic leading character. Function skipped : {} ", (Object)name);
            ++skipCount;
        }
        logger.debug("{} functions will not be available in WebUI", (Object)skipCount);
        File functionsListFile = new File(this.getOrCreateTmpJavaScriptDir(), ACE_MODE_SQL_JS);
        try (InputStream aceModeSqlTemplateStream = Resource.newClassPathResource((String)ACE_MODE_SQL_TEMPLATE_JS).getInputStream();){
            Files.copy(aceModeSqlTemplateStream, functionsListFile.toPath(), new CopyOption[0]);
        }
        String funcListString = String.join((CharSequence)"|", functionSet);
        Path path = Paths.get(functionsListFile.getPath(), new String[0]);
        try (Stream<String> lines = Files.lines(path);){
            List replaced = lines.map(line -> line.replaceFirst(DRILL_FUNCTIONS_PLACEHOLDER, funcListString)).collect(Collectors.toList());
            Files.write(path, replaced, new OpenOption[0]);
        }
    }
}

