/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.WebUtils;
import org.apache.drill.exec.work.WorkManager;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@PermitAll
public class StatusResources {
    static final Logger logger = LoggerFactory.getLogger(StatusResources.class);
    public static final String REST_API_SUFFIX = ".json";
    public static final String PATH_STATUS_JSON = "/status.json";
    public static final String PATH_STATUS = "/status";
    public static final String PATH_METRICS = "/status/metrics";
    public static final String PATH_OPTIONS_JSON = "/options.json";
    public static final String PATH_INTERNAL_OPTIONS_JSON = "/internal_options.json";
    public static final String PATH_OPTIONS = "/options";
    public static final String PATH_INTERNAL_OPTIONS = "/internal_options";
    private static final String CURRENT_FILTER_PARAM = "filter";
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    WorkManager work;
    @Inject
    SecurityContext sc;
    @Inject
    HttpServletRequest request;

    @GET
    @Path(value="/status.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public Pair<String, String> getStatusJSON() {
        return new ImmutablePair((Object)"status", (Object)"Running!");
    }

    @GET
    @Path(value="/status")
    @Produces(value={"text/html"})
    public Viewable getStatus() {
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/status.ftl", this.sc, this.getStatusJSON());
    }

    @GET
    @Path(value="/status/metrics/{hostname}")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public String getMetrics(@PathParam(value="hostname") String hostname) throws Exception {
        URL metricsURL = WebUtils.getDrillbitURL(this.work, this.request, hostname, PATH_METRICS);
        return WebUtils.doHTTPRequest((HttpRequestBase)new HttpGet(metricsURL.toURI()), this.work.getContext().getConfig());
    }

    private List<OptionWrapper> getSystemOptionsJSONHelper(boolean internal) {
        LinkedList<OptionWrapper> options = new LinkedList<OptionWrapper>();
        SystemOptionManager optionManager = this.work.getContext().getOptionManager();
        OptionList optionList = internal ? optionManager.getInternalOptionList() : optionManager.getPublicOptionList();
        for (OptionValue option : optionList) {
            options.add(new OptionWrapper(option.name, option.getValue(), optionManager.getDefault(option.name).getValue().toString(), option.accessibleScopes, option.kind, option.scope));
        }
        Collections.sort(options, new Comparator<OptionWrapper>(){

            @Override
            public int compare(OptionWrapper o1, OptionWrapper o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return options;
    }

    @GET
    @Path(value="/options.json")
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public List<OptionWrapper> getSystemPublicOptionsJSON() {
        return this.getSystemOptionsJSONHelper(false);
    }

    @GET
    @Path(value="/internal_options.json")
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"application/json"})
    public List<OptionWrapper> getSystemInternalOptionsJSON() {
        return this.getSystemOptionsJSONHelper(true);
    }

    private Viewable getSystemOptionsHelper(boolean internal, UriInfo uriInfo) {
        String currFilter;
        List<OptionWrapper> options = this.getSystemOptionsJSONHelper(internal);
        ArrayList<String> fltrList = new ArrayList<String>(this.work.getContext().getConfig().getStringList("drill.exec.http.web.options.filters"));
        String string = currFilter = uriInfo != null ? (String)uriInfo.getQueryParameters().getFirst((Object)CURRENT_FILTER_PARAM) : null;
        if (currFilter == null) {
            currFilter = "";
        }
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/options.ftl", this.sc, new OptionsListing(options, fltrList, currFilter, this.request));
    }

    @GET
    @Path(value="/options")
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"text/html"})
    public Viewable getSystemPublicOptions(@Context UriInfo uriInfo) {
        return this.getSystemOptionsHelper(false, uriInfo);
    }

    @GET
    @Path(value="/internal_options")
    @RolesAllowed(value={"authenticated"})
    @Produces(value={"text/html"})
    public Viewable getSystemInternalOptions(@Context UriInfo uriInfo) {
        return this.getSystemOptionsHelper(true, uriInfo);
    }

    @POST
    @Path(value="option/{optionName}")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public Viewable updateSystemOption(@FormParam(value="name") String name, @FormParam(value="value") String value, @FormParam(value="kind") String kind) {
        SystemOptionManager optionManager = this.work.getContext().getOptionManager();
        try {
            optionManager.setLocalOption(OptionValue.Kind.valueOf(kind), name, value);
        }
        catch (Exception e) {
            logger.debug("Could not update.", (Throwable)e);
        }
        if (optionManager.getOptionDefinition(name).getMetaData().isInternal()) {
            return this.getSystemInternalOptions(null);
        }
        return this.getSystemPublicOptions(null);
    }

    @XmlRootElement
    public static class OptionWrapper {
        private String name;
        private Object value;
        private String defaultValue;
        private OptionValue.AccessibleScopes accessibleScopes;
        private String kind;
        private String optionScope;

        @JsonCreator
        public OptionWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="value") Object value, @JsonProperty(value="defaultValue") String defaultValue, @JsonProperty(value="accessibleScopes") OptionValue.AccessibleScopes type, @JsonProperty(value="kind") OptionValue.Kind kind, @JsonProperty(value="optionScope") OptionValue.OptionScope scope) {
            this.name = name;
            this.value = value;
            this.defaultValue = defaultValue;
            this.accessibleScopes = type;
            this.kind = kind.name();
            this.optionScope = scope.name();
        }

        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public String getValueAsString() {
            return this.value.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public OptionValue.AccessibleScopes getAccessibleScopes() {
            return this.accessibleScopes;
        }

        public String getKind() {
            return this.kind;
        }

        public String getOptionScope() {
            return this.optionScope;
        }

        public String toString() {
            return "OptionWrapper{name='" + this.name + '\'' + ", value=" + this.value + ", default=" + this.defaultValue + ", accessibleScopes=" + (Object)((Object)this.accessibleScopes) + ", kind='" + this.kind + '\'' + ", scope='" + this.optionScope + '\'' + '}';
        }
    }

    public static class OptionsListing {
        private final List<OptionWrapper> options;
        private final List<String> filters;
        private final String dynamicFilter;
        private final String csrfToken;

        public OptionsListing(List<OptionWrapper> optList, List<String> fltrList, String currFilter, HttpServletRequest request) {
            this.options = optList;
            this.filters = fltrList;
            this.dynamicFilter = currFilter;
            this.csrfToken = WebUtils.getCsrfTokenFromHttpRequest(request);
        }

        public List<OptionWrapper> getOptions() {
            return this.options;
        }

        public List<String> getFilters() {
            return this.filters;
        }

        public String getDynamicFilter() {
            return this.dynamicFilter;
        }

        public String getCsrfToken() {
            return this.csrfToken;
        }
    }
}

