/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.shaded.guava.com.google.common.base.CharMatcher;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.parquet.Strings;

@XmlRootElement
public class QueryWrapper {
    private final String query;
    private final String queryType;
    final int autoLimitRowCount;
    final String userName;
    final String defaultSchema;
    final Map<String, String> options;

    protected QueryWrapper(String query, String queryType, int rowCountLimit, String userName, String defaultSchema, Map<String, String> options) {
        this.query = query;
        this.queryType = queryType.toUpperCase();
        this.autoLimitRowCount = rowCountLimit;
        this.userName = userName;
        this.defaultSchema = defaultSchema;
        this.options = options;
    }

    @JsonCreator
    public QueryWrapper(@JsonProperty(value="query") String query, @JsonProperty(value="queryType") String queryType, @JsonProperty(value="autoLimit") String autoLimit, @JsonProperty(value="userName") String userName, @JsonProperty(value="defaultSchema") String defaultSchema, @JsonProperty(value="options") Map<String, String> options) {
        this(query, queryType, QueryWrapper.mapCount(autoLimit), userName, defaultSchema, options);
    }

    private static int mapCount(String rowLimit) {
        if (Strings.isNullOrEmpty((String)rowLimit)) {
            return 0;
        }
        try {
            return Integer.parseInt(rowLimit.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getAutoLimitRowCount() {
        return this.autoLimitRowCount;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String toString() {
        return new PlanStringBuilder(this).field("query", this.query).field("query type", this.queryType).field("user name", this.userName).field("default schema", this.defaultSchema).field("row limit", this.autoLimitRowCount).toString();
    }

    public static final class RestQueryBuilder {
        private String query;
        private String queryType = UserBitShared.QueryType.SQL.name();
        private int rowLimit;
        private String userName;
        private String defaultSchema;
        private Map<String, String> options;

        public RestQueryBuilder query(String query) {
            this.query = query;
            return this;
        }

        public RestQueryBuilder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        public RestQueryBuilder rowLimit(int rowLimit) {
            this.rowLimit = rowLimit;
            return this;
        }

        public RestQueryBuilder rowLimit(String rowLimit) {
            this.rowLimit = QueryWrapper.mapCount(rowLimit);
            return this;
        }

        public RestQueryBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public RestQueryBuilder defaultSchema(String defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public RestQueryBuilder sessionOptions(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public QueryWrapper build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty((String)this.query));
            this.query = CharMatcher.is(';').trimTrailingFrom(this.query.trim());
            Preconditions.checkArgument(!this.query.isEmpty());
            return new QueryWrapper(this.query, this.queryType, this.rowLimit, this.userName, this.defaultSchema, this.options);
        }
    }
}

