/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.PluginConfigWrapper;
import org.apache.drill.exec.server.rest.QueryWrapper;
import org.apache.drill.exec.server.rest.RestQueryRunner;
import org.apache.drill.exec.server.rest.StorageResources;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.WebServer;
import org.apache.drill.exec.server.rest.WebUserConnection;
import org.apache.drill.exec.server.rest.WebUtils;
import org.apache.drill.exec.server.rest.stream.QueryRunner;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RolesAllowed(value={"authenticated"})
public class QueryResources {
    private static final Logger logger = LoggerFactory.getLogger(QueryResources.class);
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    WorkManager work;
    @Inject
    SecurityContext sc;
    @Inject
    WebUserConnection webUserConnection;
    @Inject
    HttpServletRequest request;
    @Inject
    StorageResources sr;

    @GET
    @Path(value="/query")
    @Produces(value={"text/html"})
    public Viewable getQuery() {
        List<StorageResources.StoragePluginModel> enabledPlugins = this.sr.getConfigsFor("enabled").stream().map(plugin -> new StorageResources.StoragePluginModel((PluginConfigWrapper)plugin, this.request, this.sc)).collect(Collectors.toList());
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/query/query.ftl", this.sc, new QueryPage(this.work, enabledPlugins, this.request));
    }

    @POST
    @Path(value="/query.json")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public StreamingOutput submitQueryJSON(QueryWrapper query) throws Exception {
        final QueryRunner runner = new QueryRunner(this.work, this.webUserConnection);
        try {
            runner.start(query);
        }
        catch (Exception e) {
            throw new WebApplicationException("Query submission failed", (Throwable)e);
        }
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try {
                    runner.sendResults(output);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WebApplicationException("JSON query failed", (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/query")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public Viewable submitQuery(@FormParam(value="query") String query, @FormParam(value="queryType") String queryType, @FormParam(value="autoLimit") String autoLimit, @FormParam(value="userName") String userName, @FormParam(value="defaultSchema") String defaultSchema, Form form) throws Exception {
        try {
            QueryWrapper wrapper = new QueryWrapper.RestQueryBuilder().query(query).queryType(queryType).rowLimit(autoLimit).userName(userName).defaultSchema(defaultSchema).sessionOptions(this.readOptionsFromForm(form)).build();
            RestQueryRunner.QueryResult result = new RestQueryRunner(wrapper, this.work, this.webUserConnection).run();
            List rowsPerPageValues = this.work.getContext().getConfig().getIntList("drill.exec.http.web.client.resultset.rowsPerPageValues");
            Collections.sort(rowsPerPageValues);
            String rowsPerPageValuesAsStr = Joiner.on(",").join(rowsPerPageValues);
            Viewable viewable = ViewableWithPermissions.create(this.authEnabled.get(), "/rest/query/result.ftl", this.sc, new TabularResult(result, rowsPerPageValuesAsStr));
            return viewable;
        }
        catch (Error | Exception e) {
            logger.error("Query from Web UI Failed: {}", e);
            Viewable viewable = ViewableWithPermissions.create(this.authEnabled.get(), "/rest/errorMessage.ftl", this.sc, e);
            return viewable;
        }
        finally {
            this.webUserConnection.cleanupSession();
        }
    }

    private Map<String, String> readOptionsFromForm(Form form) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Map.Entry pair : form.asMap().entrySet()) {
            List values = (List)pair.getValue();
            if (values.isEmpty()) continue;
            if (values.size() > 1) {
                throw new BadRequestException(String.format("Multiple values given for option '%s'", pair.getKey()));
            }
            options.put((String)pair.getKey(), (String)values.get(0));
        }
        return options;
    }

    public static class QueryPage {
        private final boolean onlyImpersonationEnabled;
        private final boolean autoLimitEnabled;
        private final int defaultRowsAutoLimited;
        private final List<StorageResources.StoragePluginModel> enabledPlugins;
        private final String csrfToken;

        public QueryPage(WorkManager work, List<StorageResources.StoragePluginModel> enabledPlugins, HttpServletRequest request) {
            DrillConfig config = work.getContext().getConfig();
            this.enabledPlugins = enabledPlugins;
            this.onlyImpersonationEnabled = WebServer.isOnlyImpersonationEnabled(config);
            this.autoLimitEnabled = config.getBoolean("drill.exec.http.web.client.resultset.autolimit.checked");
            this.defaultRowsAutoLimited = config.getInt("drill.exec.http.web.client.resultset.autolimit.rows");
            this.csrfToken = WebUtils.getCsrfTokenFromHttpRequest(request);
        }

        public boolean isOnlyImpersonationEnabled() {
            return this.onlyImpersonationEnabled;
        }

        public boolean isAutoLimitEnabled() {
            return this.autoLimitEnabled;
        }

        public int getDefaultRowsAutoLimited() {
            return this.defaultRowsAutoLimited;
        }

        public List<StorageResources.StoragePluginModel> getEnabledPlugins() {
            return this.enabledPlugins;
        }

        public String getCsrfToken() {
            return this.csrfToken;
        }
    }

    public static class TabularResult {
        private final List<String> columns;
        private final List<List<String>> rows;
        private final String queryId;
        private final String rowsPerPageValues;
        private final String queryState;
        private final int autoLimitedRowCount;

        public TabularResult(RestQueryRunner.QueryResult result, String rowsPerPageValuesAsStr) {
            this.rowsPerPageValues = rowsPerPageValuesAsStr;
            this.queryId = result.getQueryId();
            ArrayList<List<String>> rows = Lists.newArrayList();
            for (Map<String, String> rowMap : result.rows) {
                ArrayList<String> row = Lists.newArrayList();
                for (String col : result.columns) {
                    row.add(rowMap.get(col));
                }
                rows.add(row);
            }
            this.columns = ImmutableList.copyOf(result.columns);
            this.rows = rows;
            this.queryState = result.queryState;
            this.autoLimitedRowCount = result.attemptedAutoLimit;
        }

        public boolean isEmpty() {
            return this.columns.isEmpty();
        }

        public String getQueryId() {
            return this.queryId;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        public String getRowsPerPageValues() {
            return this.rowsPerPageValues;
        }

        public String getQueryState() {
            return this.queryState;
        }

        public boolean isResultSetAutoLimited() {
            return this.autoLimitedRowCount > 0 && this.rows.size() == this.autoLimitedRowCount;
        }

        public int getAutoLimitedRowCount() {
            return this.autoLimitedRowCount;
        }
    }
}

