/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.exec.oauth.OAuthTokenProvider;
import org.apache.drill.exec.oauth.PersistentTokenTable;
import org.apache.drill.exec.oauth.TokenRegistry;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.OAuthTokenContainer;
import org.apache.drill.exec.server.rest.StorageResources;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.http.oauth.OAuthUtils;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthRequests {
    private static final Logger logger = LoggerFactory.getLogger(OAuthRequests.class);
    private static final String OAUTH_SUCCESS_PAGE = "/rest/storage/success.html";

    public static Response updateAccessToken(String name, OAuthTokenContainer tokens, StoragePluginRegistry storage, DrillRestServer.UserAuthEnabled authEnabled, SecurityContext sc) {
        try {
            DrillbitContext context = ((AbstractStoragePlugin)storage.getPlugin(name)).getContext();
            OAuthTokenProvider tokenProvider = context.getOauthTokenProvider();
            PersistentTokenTable tokenTable = tokenProvider.getOauthTokenRegistry(OAuthRequests.getQueryUser(storage.getPlugin(name).getConfig(), authEnabled, sc)).getTokenTable(name);
            tokenTable.setAccessToken(tokens.getAccessToken());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Access tokens have been updated.").build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error when adding tokens to {}", (Object)name);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)OAuthRequests.message("Unable to add tokens: %s", e.getMessage())).build();
        }
    }

    public static Response updateRefreshToken(String name, OAuthTokenContainer tokens, StoragePluginRegistry storage, DrillRestServer.UserAuthEnabled authEnabled, SecurityContext sc) {
        try {
            DrillbitContext context = ((AbstractStoragePlugin)storage.getPlugin(name)).getContext();
            OAuthTokenProvider tokenProvider = context.getOauthTokenProvider();
            PersistentTokenTable tokenTable = tokenProvider.getOauthTokenRegistry(OAuthRequests.getQueryUser(storage.getPlugin(name).getConfig(), authEnabled, sc)).getTokenTable(name);
            tokenTable.setRefreshToken(tokens.getRefreshToken());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Refresh token have been updated.").build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error when adding tokens to {}", (Object)name);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)OAuthRequests.message("Unable to add tokens: %s", e.getMessage())).build();
        }
    }

    public static Response updateOAuthTokens(String name, OAuthTokenContainer tokenContainer, StoragePluginRegistry storage, DrillRestServer.UserAuthEnabled authEnabled, SecurityContext sc) {
        try {
            DrillbitContext context = ((AbstractStoragePlugin)storage.getPlugin(name)).getContext();
            OAuthTokenProvider tokenProvider = context.getOauthTokenProvider();
            PersistentTokenTable tokenTable = tokenProvider.getOauthTokenRegistry(OAuthRequests.getQueryUser(storage.getPlugin(name).getConfig(), authEnabled, sc)).getTokenTable(name);
            tokenTable.setAccessToken(tokenContainer.getAccessToken());
            tokenTable.setRefreshToken(tokenContainer.getRefreshToken());
            tokenTable.setExpiresIn(tokenContainer.getExpiresIn());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Access tokens have been updated.").build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error when adding tokens to {}", (Object)name);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)OAuthRequests.message("Unable to add tokens: %s", e.getMessage())).build();
        }
    }

    public static Response updateAuthToken(String name, String code, HttpServletRequest request, StoragePluginRegistry storage, DrillRestServer.UserAuthEnabled authEnabled, SecurityContext sc) {
        try {
            CredentialsProvider credentialsProvider = storage.getPlugin(name).getConfig().getCredentialsProvider();
            String callbackURL = request.getRequestURL().toString();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            OkHttpClient client = builder.build();
            Request accessTokenRequest = OAuthUtils.getAccessTokenRequest(credentialsProvider, code, callbackURL);
            Map<String, String> updatedTokens = OAuthUtils.getOAuthTokens(client, accessTokenRequest);
            TokenRegistry tokenRegistry = ((AbstractStoragePlugin)storage.getPlugin(name)).getContext().getOauthTokenProvider().getOauthTokenRegistry(OAuthRequests.getQueryUser(storage.getPlugin(name).getConfig(), authEnabled, sc));
            tokenRegistry.createTokenTable(name);
            PersistentTokenTable tokenTable = tokenRegistry.getTokenTable(name);
            tokenTable.setAccessToken(updatedTokens.get("accessToken"));
            tokenTable.setRefreshToken(updatedTokens.get("refreshToken"));
            if (updatedTokens.containsKey("expiresIn")) {
                tokenTable.setExpiresIn(updatedTokens.get("expiresIn"));
            }
            String successPage = null;
            try (InputStream inputStream = Resource.newClassPathResource((String)OAUTH_SUCCESS_PAGE).getInputStream();){
                InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(reader);
                successPage = bufferedReader.lines().collect(Collectors.joining("\n"));
                bufferedReader.close();
                reader.close();
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"You may close this window.").build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)successPage).build();
        }
        catch (StoragePluginRegistry.PluginException e) {
            logger.error("Error when adding auth token to {}", (Object)name);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)OAuthRequests.message("Unable to add authorization code: %s", e.getMessage())).build();
        }
    }

    private static StorageResources.JsonResult message(String message, Object ... args) {
        return new StorageResources.JsonResult(String.format(message, args));
    }

    private static String getQueryUser(StoragePluginConfig config, DrillRestServer.UserAuthEnabled authEnabled, SecurityContext sc) {
        if (config.getAuthMode() == StoragePluginConfig.AuthMode.USER_TRANSLATION && authEnabled.get()) {
            return sc.getUserPrincipal().getName();
        }
        return null;
    }
}

