/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.server.rest.ViewableWithPermissions;
import org.apache.drill.exec.server.rest.WebUtils;
import org.apache.drill.exec.server.rest.auth.AuthDynamicFeature;
import org.apache.drill.exec.server.rest.auth.DrillUserPrincipal;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.rm.DistributedQueryQueue;
import org.apache.drill.exec.work.foreman.rm.DynamicResourceManager;
import org.apache.drill.exec.work.foreman.rm.QueryQueue;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;
import org.apache.drill.exec.work.foreman.rm.ThrottledResourceManager;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@PermitAll
public class DrillRoot {
    private static final Logger logger = LoggerFactory.getLogger(DrillRoot.class);
    @Inject
    DrillRestServer.UserAuthEnabled authEnabled;
    @Inject
    WorkManager work;
    @Inject
    SecurityContext sc;
    @Inject
    Drillbit drillbit;
    @Inject
    HttpServletRequest request;

    @GET
    @Produces(value={"text/html"})
    public Viewable getClusterInfo() {
        return ViewableWithPermissions.create(this.authEnabled.get(), "/rest/index.ftl", this.sc, this.getClusterInfoJSON());
    }

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    public Response getDrillbitStatus() {
        Collection<DrillbitInfo> drillbits = this.getClusterInfoJSON().getDrillbits();
        HashMap<String, String> drillStatusMap = new HashMap<String, String>();
        for (DrillbitInfo drillbit : drillbits) {
            drillStatusMap.put(drillbit.getAddress() + "-" + drillbit.getHttpPort(), drillbit.getState());
        }
        return this.setResponse(drillStatusMap);
    }

    @GET
    @Path(value="/gracePeriod")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="  https://drill.apache.org/docs/stopping-drill/"))
    public Map<String, Integer> getGracePeriod() {
        DrillConfig config = this.work.getContext().getConfig();
        int gracePeriod = config.getInt("drill.exec.grace_period_ms");
        HashMap<String, Integer> gracePeriodMap = new HashMap<String, Integer>();
        gracePeriodMap.put("gracePeriod", gracePeriod);
        return gracePeriodMap;
    }

    @GET
    @Path(value="/portNum")
    @Produces(value={"application/json"})
    public Map<String, Integer> getPortNum() {
        DrillConfig config = this.work.getContext().getConfig();
        int port = config.getInt("drill.exec.http.port");
        HashMap<String, Integer> portMap = new HashMap<String, Integer>();
        portMap.put("port", port);
        return portMap;
    }

    @GET
    @Path(value="/queriesCount")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/apidocs/org/apache/drill/exec/work/WorkManager.html"))
    public Response getRemainingQueries() {
        Map<String, Integer> queriesInfo = this.work.getRemainingQueries();
        return this.setResponse(queriesInfo);
    }

    @POST
    @Path(value="/gracefulShutdown")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/stopping-drill/"))
    public Response shutdownDrillbit() throws Exception {
        String resp = "Graceful Shutdown request is triggered";
        return this.shutdown(resp);
    }

    @POST
    @Path(value="/gracefulShutdown/{hostname}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/stopping-drill/"))
    public String shutdownDrillbitByName(@PathParam(value="hostname") String hostname) throws Exception {
        URL shutdownURL = WebUtils.getDrillbitURL(this.work, this.request, hostname, "/gracefulShutdown");
        return WebUtils.doHTTPRequest((HttpRequestBase)new HttpPost(shutdownURL.toURI()), this.work.getContext().getConfig());
    }

    @POST
    @Path(value="/shutdown")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/stopping-drill/"))
    public Response shutdownForcefully() throws Exception {
        this.drillbit.setForcefulShutdown(true);
        String resp = "Forceful shutdown request is triggered";
        return this.shutdown(resp);
    }

    @POST
    @Path(value="/quiescent")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"admin"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/stopping-drill/"))
    public Response drillbitToQuiescentMode() throws Exception {
        this.drillbit.setQuiescentMode(true);
        String resp = "Request to put drillbit in Quiescent mode is triggered";
        return this.shutdown(resp);
    }

    @GET
    @Path(value="/cluster.json")
    @Produces(value={"application/json"})
    @Operation(externalDocs=@ExternalDocumentation(description="Apache Drill REST API documentation:", url="https://drill.apache.org/docs/rest-api-introduction/"))
    public ClusterInfo getClusterInfoJSON() {
        TreeSet<DrillbitInfo> drillbits = Sets.newTreeSet();
        TreeSet<String> mismatchedVersions = Sets.newTreeSet();
        DrillbitContext dbContext = this.work.getContext();
        CoordinationProtos.DrillbitEndpoint currentDrillbit = dbContext.getEndpoint();
        String currentVersion = currentDrillbit.getVersion();
        DrillConfig config = dbContext.getConfig();
        boolean userEncryptionEnabled = config.getBoolean("drill.exec.security.user.encryption.sasl.enabled") || config.getBoolean("drill.exec.security.user.encryption.ssl.enabled");
        boolean bitEncryptionEnabled = config.getBoolean("drill.exec.security.bit.encryption.sasl.enabled");
        SystemOptionManager optionManager = this.work.getContext().getOptionManager();
        boolean isUserLoggedIn = AuthDynamicFeature.isUserLoggedIn(this.sc);
        boolean shouldShowAdminInfo = isUserLoggedIn && ((DrillUserPrincipal)this.sc.getUserPrincipal()).isAdminUser();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.work.getContext().getAvailableBits()) {
            DrillbitInfo drillbit = new DrillbitInfo(endpoint, this.isDrillbitsTheSame(currentDrillbit, endpoint), currentVersion.equals(endpoint.getVersion()));
            if (!drillbit.isVersionMatch()) {
                mismatchedVersions.add(drillbit.getVersion());
            }
            drillbits.add(drillbit);
        }
        if (shouldShowAdminInfo) {
            String processUser = ImpersonationUtil.getProcessUserName();
            String processUserGroups = Joiner.on(", ").join(ImpersonationUtil.getProcessUserGroupNames());
            String adminUsers = ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(optionManager);
            String adminUserGroups = ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(optionManager);
            logger.debug("Admin info: user: {} user group: {} userLoggedIn {} shouldShowAdminInfo: {}", new Object[]{adminUsers, adminUserGroups, isUserLoggedIn, shouldShowAdminInfo});
            return new ClusterInfo(drillbits, currentVersion, mismatchedVersions, userEncryptionEnabled, bitEncryptionEnabled, shouldShowAdminInfo, QueueInfo.build(dbContext.getResourceManager()), processUser, processUserGroups, adminUsers, adminUserGroups, this.authEnabled.get());
        }
        return new ClusterInfo(drillbits, currentVersion, mismatchedVersions, userEncryptionEnabled, bitEncryptionEnabled, shouldShowAdminInfo, QueueInfo.build(dbContext.getResourceManager()), this.authEnabled.get());
    }

    private boolean isDrillbitsTheSame(CoordinationProtos.DrillbitEndpoint endpoint1, CoordinationProtos.DrillbitEndpoint endpoint2) {
        return endpoint1.getAddress().equals(endpoint2.getAddress()) && endpoint1.getControlPort() == endpoint2.getControlPort() && endpoint1.getDataPort() == endpoint2.getDataPort() && endpoint1.getUserPort() == endpoint2.getUserPort();
    }

    private Response setResponse(Map<String, ?> entity) {
        return Response.ok().entity(entity).header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET, POST, DELETE, PUT").header("Access-Control-Allow-Credentials", (Object)"true").allow(new String[]{"OPTIONS"}).build();
    }

    private Response shutdown(String resp) throws Exception {
        HashMap<String, String> shutdownInfo = new HashMap<String, String>();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DrillRoot.this.drillbit.close();
                }
                catch (Exception e) {
                    logger.error("Request to shutdown drillbit failed", (Throwable)e);
                }
            }
        }).start();
        shutdownInfo.put("response", resp);
        return this.setResponse(shutdownInfo);
    }

    @XmlRootElement
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class ClusterInfo {
        private final Collection<DrillbitInfo> drillbits;
        private final String currentVersion;
        private final Collection<String> mismatchedVersions;
        private final boolean userEncryptionEnabled;
        private final boolean bitEncryptionEnabled;
        private final boolean shouldShowAdminInfo;
        private final boolean authEnabled;
        private final QueueInfo queueInfo;
        private String adminUsers;
        private String adminUserGroups;
        private String processUser;
        private String processUserGroups;

        @JsonCreator
        public ClusterInfo(Collection<DrillbitInfo> drillbits, String currentVersion, Collection<String> mismatchedVersions, boolean userEncryption, boolean bitEncryption, boolean shouldShowAdminInfo, QueueInfo queueInfo, boolean authEnabled) {
            this.drillbits = Sets.newTreeSet(drillbits);
            this.currentVersion = currentVersion;
            this.mismatchedVersions = Sets.newTreeSet(mismatchedVersions);
            this.userEncryptionEnabled = userEncryption;
            this.bitEncryptionEnabled = bitEncryption;
            this.shouldShowAdminInfo = shouldShowAdminInfo;
            this.queueInfo = queueInfo;
            this.authEnabled = authEnabled;
        }

        @JsonCreator
        public ClusterInfo(Collection<DrillbitInfo> drillbits, String currentVersion, Collection<String> mismatchedVersions, boolean userEncryption, boolean bitEncryption, boolean shouldShowAdminInfo, QueueInfo queueInfo, String processUser, String processUserGroups, String adminUsers, String adminUserGroups, boolean authEnabled) {
            this(drillbits, currentVersion, mismatchedVersions, userEncryption, bitEncryption, shouldShowAdminInfo, queueInfo, authEnabled);
            this.processUser = processUser;
            this.processUserGroups = processUserGroups;
            this.adminUsers = adminUsers;
            this.adminUserGroups = adminUserGroups;
        }

        public Collection<DrillbitInfo> getDrillbits() {
            return Sets.newTreeSet(this.drillbits);
        }

        public String getCurrentVersion() {
            return this.currentVersion;
        }

        public Collection<String> getMismatchedVersions() {
            return Sets.newTreeSet(this.mismatchedVersions);
        }

        public boolean isUserEncryptionEnabled() {
            return this.userEncryptionEnabled;
        }

        public boolean isBitEncryptionEnabled() {
            return this.bitEncryptionEnabled;
        }

        public String getProcessUser() {
            return this.processUser;
        }

        public String getProcessUserGroups() {
            return this.processUserGroups;
        }

        public String getAdminUsers() {
            return this.adminUsers;
        }

        public String getAdminUserGroups() {
            return this.adminUserGroups;
        }

        public boolean shouldShowAdminInfo() {
            return this.shouldShowAdminInfo;
        }

        public QueueInfo queueInfo() {
            return this.queueInfo;
        }

        public boolean isAuthEnabled() {
            return this.authEnabled;
        }
    }

    public static class DrillbitInfo
    implements Comparable<DrillbitInfo> {
        private final String address;
        private final String httpPort;
        private final String userPort;
        private final String controlPort;
        private final String dataPort;
        private final String version;
        private final boolean current;
        private final boolean versionMatch;
        private final String state;

        @JsonCreator
        public DrillbitInfo(CoordinationProtos.DrillbitEndpoint drillbit, boolean current, boolean versionMatch) {
            this.address = drillbit.getAddress();
            this.httpPort = String.valueOf(drillbit.getHttpPort());
            this.userPort = String.valueOf(drillbit.getUserPort());
            this.controlPort = String.valueOf(drillbit.getControlPort());
            this.dataPort = String.valueOf(drillbit.getDataPort());
            this.version = Strings.isNullOrEmpty(drillbit.getVersion()) ? "Undefined" : drillbit.getVersion();
            this.current = current;
            this.versionMatch = versionMatch;
            this.state = String.valueOf(drillbit.getState());
        }

        public String getAddress() {
            return this.address;
        }

        public String getHttpPort() {
            return this.httpPort;
        }

        public String getUserPort() {
            return this.userPort;
        }

        public String getControlPort() {
            return this.controlPort;
        }

        public String getDataPort() {
            return this.dataPort;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public boolean isVersionMatch() {
            return this.versionMatch;
        }

        public String getState() {
            return this.state;
        }

        @Override
        public int compareTo(DrillbitInfo drillbitToCompare) {
            if (this.isCurrent()) {
                return -1;
            }
            if (drillbitToCompare.isCurrent()) {
                return 1;
            }
            if (this.isVersionMatch() == drillbitToCompare.isVersionMatch()) {
                if (this.version.equals(drillbitToCompare.getVersion())) {
                    if (this.address.equals(drillbitToCompare.getAddress())) {
                        return this.controlPort.compareTo(drillbitToCompare.getControlPort());
                    }
                    return this.address.compareTo(drillbitToCompare.getAddress());
                }
                return this.version.compareTo(drillbitToCompare.getVersion());
            }
            return this.versionMatch ? -1 : 1;
        }
    }

    @XmlRootElement
    public static class QueueInfo {
        private final DistributedQueryQueue.ZKQueueInfo zkQueueInfo;
        private final long ONE_MB = 0x100000L;

        public static QueueInfo build(ResourceManager rm) {
            ThrottledResourceManager throttledRM = null;
            if (rm != null && rm instanceof DynamicResourceManager) {
                DynamicResourceManager dynamicRM = (DynamicResourceManager)rm;
                rm = dynamicRM.activeRM();
            }
            if (rm != null && rm instanceof ThrottledResourceManager) {
                throttledRM = (ThrottledResourceManager)rm;
            }
            if (throttledRM == null) {
                return new QueueInfo(null);
            }
            QueryQueue queue = throttledRM.queue();
            if (queue == null || !(queue instanceof DistributedQueryQueue)) {
                return new QueueInfo(null);
            }
            return new QueueInfo(((DistributedQueryQueue)queue).getInfo());
        }

        @JsonCreator
        public QueueInfo(DistributedQueryQueue.ZKQueueInfo queueInfo) {
            this.zkQueueInfo = queueInfo;
        }

        public boolean isEnabled() {
            return this.zkQueueInfo != null;
        }

        public int smallQueueSize() {
            return this.isEnabled() ? this.zkQueueInfo.smallQueueSize : 0;
        }

        public int largeQueueSize() {
            return this.isEnabled() ? this.zkQueueInfo.largeQueueSize : 0;
        }

        public String threshold() {
            return this.isEnabled() ? Double.toString(this.zkQueueInfo.queueThreshold) : "N/A";
        }

        public String smallQueueMemory() {
            return this.isEnabled() ? this.toBytes(this.zkQueueInfo.memoryPerSmallQuery) : "N/A";
        }

        public String largeQueueMemory() {
            return this.isEnabled() ? this.toBytes(this.zkQueueInfo.memoryPerLargeQuery) : "N/A";
        }

        public String totalMemory() {
            return this.isEnabled() ? this.toBytes(this.zkQueueInfo.memoryPerNode) : "N/A";
        }

        private String toBytes(long memory) {
            if (memory < 0xA00000L) {
                return String.format("%,d bytes", memory);
            }
            return String.format("%,.0f MB", (double)memory * 1.0 / 1048576.0);
        }
    }
}

