/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.rest;

import java.util.Map;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.tools.ValidationException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.UserClientConnection;
import org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.apache.drill.exec.server.rest.WebUserConnection;
import org.apache.drill.exec.store.SchemaTreeProvider;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.work.WorkManager;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueryRunner {
    private static final Logger logger = LoggerFactory.getLogger(BaseQueryRunner.class);
    protected final WorkManager workManager;
    protected final WebUserConnection webUserConnection;
    private final OptionSet options;
    protected int maxRows;
    protected UserBitShared.QueryId queryId;

    public BaseQueryRunner(WorkManager workManager, WebUserConnection webUserConnection) {
        this.workManager = workManager;
        this.webUserConnection = webUserConnection;
        this.options = webUserConnection.getSession().getOptions();
        this.maxRows = this.options.getInt("exec.query.max_rows");
    }

    protected void applyUserName(String userName) {
        boolean isAdmin;
        if (Strings.isNullOrEmpty((String)userName)) {
            return;
        }
        DrillConfig config = this.workManager.getContext().getConfig();
        if (!config.getBoolean("drill.exec.impersonation.enabled")) {
            throw UserException.permissionError().message("User impersonation is not enabled", new Object[0]).build(logger);
        }
        String proxyUserName = this.webUserConnection.getSession().getCredentials().getUserName();
        if (proxyUserName.equals(userName)) {
            return;
        }
        InboundImpersonationManager inboundImpersonationManager = new InboundImpersonationManager();
        boolean bl = isAdmin = !config.getBoolean("drill.exec.security.user.auth.enabled") || ImpersonationUtil.hasAdminPrivileges(proxyUserName, ExecConstants.ADMIN_USERS_VALIDATOR.getAdminUsers(this.options), ExecConstants.ADMIN_USER_GROUPS_VALIDATOR.getAdminUserGroups(this.options));
        if (isAdmin) {
            this.webUserConnection.getSession().replaceUserCredentials(inboundImpersonationManager, UserBitShared.UserCredentials.newBuilder().setUserName(userName).build());
        } else {
            inboundImpersonationManager.replaceUserOnSession(userName, this.webUserConnection.getSession());
        }
    }

    protected void applyOptions(Map<String, String> options) {
        if (options != null) {
            SessionOptionManager sessionOptionManager = this.webUserConnection.getSession().getOptions();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                sessionOptionManager.setLocalOption(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void applyDefaultSchema(String defaultSchema) throws ValidationException {
        if (!Strings.isNullOrEmpty((String)defaultSchema)) {
            SessionOptionManager options = this.webUserConnection.getSession().getOptions();
            SchemaTreeProvider schemaTreeProvider = new SchemaTreeProvider(this.workManager.getContext());
            SchemaPlus rootSchema = schemaTreeProvider.createRootSchema(options);
            this.webUserConnection.getSession().setDefaultSchemaPath(defaultSchema, rootSchema);
        }
    }

    protected void applyRowLimit(int limit) {
        this.maxRows = limit > 0 && this.maxRows > 0 ? Math.min(limit, this.maxRows) : Math.max(limit, this.maxRows);
    }

    protected void startQuery(UserBitShared.QueryType queryType, String query, UserClientConnection clientConn) {
        UserProtos.RunQuery runQuery = UserProtos.RunQuery.newBuilder().setType(queryType).setPlan(query).setResultsMode(UserProtos.QueryResultsMode.STREAM_FULL).setAutolimitRowcount(this.maxRows).build();
        this.queryId = this.workManager.getUserWorker().submitWork(clientConn, runQuery);
    }
}

