/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import java.util.Map;
import org.apache.drill.exec.server.options.FallbackOptionManager;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;

public abstract class InMemoryOptionManager
extends FallbackOptionManager {
    protected final Map<String, OptionValue> options;

    InMemoryOptionManager(OptionManager fallback, Map<String, OptionValue> options) {
        super(fallback);
        this.options = options;
    }

    @Override
    OptionValue getLocalOption(String name) {
        return this.options.get(name);
    }

    @Override
    public void setLocalOptionHelper(OptionValue value) {
        this.options.put(value.name, value);
    }

    @Override
    Iterable<OptionValue> getLocalOptions() {
        return this.options.values();
    }

    @Override
    public void deleteAllLocalOptions() {
        this.options.clear();
    }

    @Override
    public void deleteLocalOption(String name) {
        this.options.remove(name);
    }
}

