/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import java.util.Iterator;
import org.apache.drill.exec.server.options.BaseOptionManager;
import org.apache.drill.exec.server.options.OptionDefinition;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.shaded.guava.com.google.common.collect.Iterables;

public abstract class FallbackOptionManager
extends BaseOptionManager {
    protected final OptionManager fallback;

    public FallbackOptionManager(OptionManager fallback) {
        this.fallback = fallback;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.fallback, this.getLocalOptions()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue value = this.getLocalOption(name);
        if (value == null && this.fallback != null) {
            return this.fallback.getOption(name);
        }
        return value;
    }

    abstract Iterable<OptionValue> getLocalOptions();

    abstract OptionValue getLocalOption(String var1);

    @Override
    public OptionDefinition getOptionDefinition(String name) {
        return this.fallback.getOptionDefinition(name);
    }

    @Override
    public OptionList getOptionList() {
        OptionList list = new OptionList();
        for (OptionValue value : this.getLocalOptions()) {
            list.add(value);
        }
        return list;
    }
}

