/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.tools.ToolProvider;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.StackTrace;
import org.apache.drill.common.concurrent.ExtendedLatch;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.common.scanner.ClassPathScanner;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.common.util.GuavaPatcher;
import org.apache.drill.common.util.ProtobufPatcher;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.zk.ZKACLProviderDelegate;
import org.apache.drill.exec.coord.zk.ZKACLProviderFactory;
import org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.DrillbitStateManager;
import org.apache.drill.exec.server.FailureUtils;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.server.StartupOptions;
import org.apache.drill.exec.server.options.OptionDefinition;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.server.rest.WebServer;
import org.apache.drill.exec.service.ServiceEngine;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.PersistentStoreProvider;
import org.apache.drill.exec.store.sys.PersistentStoreRegistry;
import org.apache.drill.exec.store.sys.store.provider.CachingPersistentStoreProvider;
import org.apache.drill.exec.store.sys.store.provider.InMemoryStoreProvider;
import org.apache.drill.exec.store.sys.store.provider.LocalPersistentStoreProvider;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.zookeeper.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Drillbit
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Drillbit.class);
    public static final String SYSTEM_OPTIONS_NAME = "org.apache.drill.exec.server.Drillbit.system_options";
    private final ClusterCoordinator coord;
    private final ServiceEngine engine;
    private final PersistentStoreProvider storeProvider;
    private final WorkManager manager;
    private final BootStrapContext context;
    private final WebServer webServer;
    private final int gracePeriod;
    private final DrillbitStateManager stateManager;
    private GracefulShutdownThread gracefulShutdownThread;
    private Thread shutdownHook;
    private volatile boolean quiescentMode;
    private volatile boolean forcefulShutdown;
    private volatile boolean interruptPollShutdown = true;
    private ClusterCoordinator.RegistrationHandle registrationHandle;
    private volatile StoragePluginRegistry storageRegistry;
    private final PersistentStoreProvider profileStoreProvider;

    public void setQuiescentMode(boolean quiescentMode) {
        this.quiescentMode = quiescentMode;
    }

    public void setForcefulShutdown(boolean forcefulShutdown) {
        this.forcefulShutdown = forcefulShutdown;
    }

    public ClusterCoordinator.RegistrationHandle getRegistrationHandle() {
        return this.registrationHandle;
    }

    @VisibleForTesting
    public Drillbit(DrillConfig config, RemoteServiceSet serviceSet) throws Exception {
        this(config, SystemOptionManager.createDefaultOptionDefinitions(), serviceSet, ClassPathScanner.fromPrescan(config));
    }

    @VisibleForTesting
    public Drillbit(DrillConfig config, CaseInsensitiveMap<OptionDefinition> definitions, RemoteServiceSet serviceSet) throws Exception {
        this(config, definitions, serviceSet, ClassPathScanner.fromPrescan(config));
    }

    public Drillbit(DrillConfig config, RemoteServiceSet serviceSet, ScanResult classpathScan) throws Exception {
        this(config, SystemOptionManager.createDefaultOptionDefinitions(), serviceSet, classpathScan);
    }

    @VisibleForTesting
    public Drillbit(DrillConfig config, CaseInsensitiveMap<OptionDefinition> definitions, RemoteServiceSet serviceSet, ScanResult classpathScan) throws Exception {
        boolean isDistributedMode;
        if (ToolProvider.getSystemJavaCompiler() == null) {
            throw new DrillbitStartupException("JDK Java compiler not available. Ensure Drill is running with the java executable from a JDK and not a JRE");
        }
        this.gracePeriod = config.getInt("drill.exec.grace_period_ms");
        Stopwatch w = Stopwatch.createStarted();
        logger.debug("Construction started.");
        boolean drillPortHunt = config.getBoolean("drill.exec.port_hunt");
        boolean bindToLoopbackAddress = config.getBoolean("drill.exec.allow_loopback_address_binding");
        boolean allowPortHunting = serviceSet != null || drillPortHunt;
        this.context = new BootStrapContext(config, definitions, classpathScan);
        this.manager = new WorkManager(this.context);
        this.webServer = new WebServer(this.context, this.manager, this);
        boolean bl = isDistributedMode = serviceSet == null && !bindToLoopbackAddress;
        if (serviceSet != null) {
            this.coord = serviceSet.getCoordinator();
            this.storeProvider = new CachingPersistentStoreProvider(new LocalPersistentStoreProvider(config));
        } else {
            String clusterId = config.getString("drill.exec.cluster-id");
            String zkRoot = config.getString("drill.exec.zk.root");
            String drillClusterPath = "/" + zkRoot + "/" + clusterId;
            ZKACLProviderDelegate aclProvider = ZKACLProviderFactory.getACLProvider(config, drillClusterPath, this.context);
            this.coord = new ZKClusterCoordinator(config, aclProvider);
            this.storeProvider = new PersistentStoreRegistry<ClusterCoordinator>(this.coord, config).newPStoreProvider();
        }
        if (config.getBoolean("drill.exec.profiles.store.inmemory")) {
            this.profileStoreProvider = new InMemoryStoreProvider(config.getInt("drill.exec.profiles.store.capacity"));
            logger.info("Upto {} latest query profiles will be retained in-memory", (Object)config.getInt("drill.exec.profiles.store.capacity"));
        } else {
            this.profileStoreProvider = this.storeProvider;
        }
        this.engine = new ServiceEngine(this.manager, this.context, allowPortHunting, isDistributedMode);
        this.stateManager = new DrillbitStateManager(DrillbitStateManager.DrillbitState.STARTUP);
        logger.info("Construction completed ({} ms).", (Object)w.elapsed(TimeUnit.MILLISECONDS));
    }

    public int getUserPort() {
        return this.engine.getUserPort();
    }

    public int getWebServerPort() {
        return this.webServer.getPort();
    }

    @VisibleForTesting
    public WorkManager getManager() {
        return this.manager;
    }

    @VisibleForTesting
    public WebServer getWebServer() {
        return this.webServer;
    }

    public void run() throws Exception {
        Stopwatch w = Stopwatch.createStarted();
        logger.debug("Startup begun.");
        this.gracefulShutdownThread = new GracefulShutdownThread(this, new StackTrace());
        this.coord.start(10000L);
        this.stateManager.setState(DrillbitStateManager.DrillbitState.ONLINE);
        this.storeProvider.start();
        if (this.profileStoreProvider != this.storeProvider) {
            this.profileStoreProvider.start();
        }
        CoordinationProtos.DrillbitEndpoint md = this.engine.start();
        this.manager.start(md, this.engine.getController(), this.engine.getDataConnectionCreator(), this.coord, this.storeProvider, this.profileStoreProvider);
        DrillbitContext drillbitContext = this.manager.getContext();
        this.storageRegistry = drillbitContext.getStorage();
        this.storageRegistry.init();
        drillbitContext.getOptionManager().init();
        this.javaPropertiesToSystemOptions();
        this.manager.getContext().getRemoteFunctionRegistry().init(this.context.getConfig(), this.storeProvider, this.coord);
        this.webServer.start();
        int httpPort = -1;
        if (this.webServer.isRunning()) {
            httpPort = this.getWebServerPort();
            md = md.toBuilder().setHttpPort(httpPort).build();
        }
        this.registrationHandle = this.coord.register(md);
        drillbitContext.startRM();
        this.shutdownHook = new ShutdownThread(this, new StackTrace());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        this.gracefulShutdownThread.start();
        logger.info("Startup completed in {} ms and running on port: {}", (Object)w.elapsed(TimeUnit.MILLISECONDS), (Object)httpPort);
    }

    private void waitForGracePeriod() {
        ExtendedLatch exitLatch = new ExtendedLatch();
        exitLatch.awaitUninterruptibly(this.gracePeriod);
    }

    private void updateState(CoordinationProtos.DrillbitEndpoint.State state) {
        if (this.registrationHandle != null) {
            this.coord.update(this.registrationHandle, state);
        }
    }

    public void shutdown() {
        this.close();
    }

    @Override
    public synchronized void close() {
        if (!this.stateManager.getState().equals((Object)DrillbitStateManager.DrillbitState.ONLINE)) {
            return;
        }
        Stopwatch w = Stopwatch.createStarted();
        logger.debug("Shutdown begun.");
        Thread shutdownHook = this.shutdownHook;
        if (shutdownHook != null && Thread.currentThread() != shutdownHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.updateState(CoordinationProtos.DrillbitEndpoint.State.QUIESCENT);
        this.stateManager.setState(DrillbitStateManager.DrillbitState.GRACE);
        this.waitForGracePeriod();
        this.stateManager.setState(DrillbitStateManager.DrillbitState.DRAINING);
        this.manager.waitToExit(this.forcefulShutdown);
        this.updateState(CoordinationProtos.DrillbitEndpoint.State.OFFLINE);
        this.stateManager.setState(DrillbitStateManager.DrillbitState.OFFLINE);
        if (this.quiescentMode) {
            return;
        }
        if (this.coord != null && this.registrationHandle != null) {
            this.coord.unregister(this.registrationHandle);
        }
        try {
            Thread.sleep((long)this.context.getConfig().getInt("drill.exec.zk.refresh") * 2L);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while sleeping during coordination deregistration.");
            Thread.currentThread().interrupt();
        }
        try {
            AutoCloseables.close(this.webServer, this.engine, this.storeProvider, this.coord, this.manager, this.storageRegistry, this.context);
            if (this.storeProvider != this.profileStoreProvider) {
                AutoCloseables.close(this.profileStoreProvider);
            }
        }
        catch (Exception e) {
            logger.warn("Failure on close()", (Throwable)e);
        }
        logger.info("Shutdown completed ({} ms).", (Object)w.elapsed(TimeUnit.MILLISECONDS));
        this.stateManager.setState(DrillbitStateManager.DrillbitState.SHUTDOWN);
        if (this.interruptPollShutdown) {
            this.gracefulShutdownThread.interrupt();
        }
    }

    private void javaPropertiesToSystemOptions() {
        String[] systemProps;
        String allSystemProps = System.getProperty(SYSTEM_OPTIONS_NAME);
        if (allSystemProps == null || allSystemProps.isEmpty()) {
            return;
        }
        SystemOptionManager optionManager = this.getContext().getOptionManager();
        for (String systemProp : systemProps = allSystemProps.split(",")) {
            OptionValue defaultValue;
            String optionString;
            String optionName;
            String[] keyValue = systemProp.split("=");
            if (keyValue.length != 2) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a key=value assignment");
            }
            if ((optionName = keyValue[0].trim()).isEmpty()) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a key before the assignment");
            }
            if ((optionString = Drillbit.stripQuotes(keyValue[1].trim(), systemProp)).isEmpty()) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not contain a value after the assignment");
            }
            if ((defaultValue = optionManager.getOption(optionName)) == null) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not specify a valid option name");
            }
            if (!defaultValue.accessibleScopes.inScopeOf(OptionValue.OptionScope.SYSTEM)) {
                Drillbit.throwInvalidSystemOption(systemProp, "does not specify a SYSTEM option ");
            }
            optionManager.setLocalOption(defaultValue.kind, optionName, optionString);
        }
    }

    public DrillbitContext getContext() {
        return this.manager.getContext();
    }

    @VisibleForTesting
    public GracefulShutdownThread getGracefulShutdownThread() {
        return this.gracefulShutdownThread;
    }

    public static void main(String[] cli) throws DrillbitStartupException {
        StartupOptions options = StartupOptions.parse(cli);
        Drillbit.start(options);
    }

    public static Drillbit start(StartupOptions options) throws DrillbitStartupException {
        return Drillbit.start(DrillConfig.create(options.getConfigLocation()), SystemOptionManager.createDefaultOptionDefinitions(), null);
    }

    public static Drillbit start(DrillConfig config) throws DrillbitStartupException {
        return Drillbit.start(config, SystemOptionManager.createDefaultOptionDefinitions(), null);
    }

    public static Drillbit start(DrillConfig config, RemoteServiceSet remoteServiceSet) throws DrillbitStartupException {
        return Drillbit.start(config, SystemOptionManager.createDefaultOptionDefinitions(), remoteServiceSet);
    }

    @VisibleForTesting
    public static Drillbit start(DrillConfig config, CaseInsensitiveMap<OptionDefinition> validators, RemoteServiceSet remoteServiceSet) throws DrillbitStartupException {
        Drillbit bit;
        logger.debug("Starting new Drillbit.");
        ScanResult classpathScan = ClassPathScanner.fromPrescan(config);
        try {
            bit = new Drillbit(config, validators, remoteServiceSet, classpathScan);
        }
        catch (Exception ex) {
            if (ex instanceof DrillbitStartupException) {
                throw (DrillbitStartupException)ex;
            }
            throw new DrillbitStartupException("Failure while initializing values in Drillbit.", ex);
        }
        try {
            bit.run();
        }
        catch (Exception e) {
            logger.error("Failure during initial startup of Drillbit.", (Throwable)e);
            bit.close();
            throw new DrillbitStartupException("Failure during initial startup of Drillbit.", e);
        }
        logger.debug("Started new Drillbit.");
        return bit;
    }

    private static void throwInvalidSystemOption(String systemProp, String errorMessage) {
        throw new IllegalStateException("Property \"org.apache.drill.exec.server.Drillbit.system_options\" part \"" + systemProp + "\" " + errorMessage + ".");
    }

    private static String stripQuotes(String s, String systemProp) {
        if (s.isEmpty()) {
            return s;
        }
        char cFirst = s.charAt(0);
        char cLast = s.charAt(s.length() - 1);
        if (cFirst == '\"' || cFirst == '\'') {
            if (cLast != cFirst) {
                Drillbit.throwInvalidSystemOption(systemProp, "quoted value does not have closing quote");
            }
            return s.substring(1, s.length() - 2);
        }
        if (cLast == '\"' || cLast == '\'') {
            Drillbit.throwInvalidSystemOption(systemProp, "value has unbalanced closing quote");
        }
        return s;
    }

    static {
        ProtobufPatcher.patch();
        GuavaPatcher.patch();
        Environment.logEnv((String)"Drillbit environment: ", (Logger)logger);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private static class GracefulShutdownThread
    extends Thread {
        private static final String DRILL_HOME = "DRILL_HOME";
        private static final String GRACEFUL_SIGFILE = "GRACEFUL_SIGFILE";
        private static final String NOT_SUPPORTED_MESSAGE = "Graceful shutdown from command line will not be supported.";
        private final Drillbit drillbit;
        private final StackTrace stackTrace;

        GracefulShutdownThread(Drillbit drillbit, StackTrace stackTrace) {
            this.drillbit = drillbit;
            this.stackTrace = stackTrace;
            this.setName("Drillbit-Graceful-Shutdown#" + this.getName());
        }

        @Override
        public void run() {
            try {
                this.pollShutdown();
            }
            catch (InterruptedException e) {
                this.drillbit.interruptPollShutdown = false;
                logger.debug("Graceful Shutdown thread was interrupted", (Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while polling for graceful shutdown\n" + this.stackTrace, e);
            }
        }

        private void pollShutdown() throws IOException, InterruptedException {
            String gracefulFile;
            Path drillHomePath = this.getDrillHomePath();
            if (!this.areShutdownArgsValid(drillHomePath, gracefulFile = System.getenv(GRACEFUL_SIGFILE))) {
                return;
            }
            while (true) {
                WatchService watchService = Objects.requireNonNull(drillHomePath).getFileSystem().newWatchService();
                try {
                    WatchKey watchKey;
                    drillHomePath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                    do {
                        watchKey = watchService.take();
                        for (WatchEvent<?> event : watchKey.pollEvents()) {
                            Path changedPath;
                            if (StandardWatchEventKinds.OVERFLOW == event.kind() || (changedPath = (Path)event.context()) == null || !changedPath.endsWith(gracefulFile)) continue;
                            this.drillbit.interruptPollShutdown = false;
                            this.drillbit.close();
                            return;
                        }
                    } while (watchKey.reset());
                    logger.debug("Watch key is no longer valid, attempting to re-register Drill home path in Watch Service");
                    continue;
                }
                finally {
                    if (watchService == null) continue;
                    watchService.close();
                    continue;
                }
                break;
            }
        }

        private Path getDrillHomePath() {
            String drillHome = System.getenv(DRILL_HOME);
            try {
                return drillHome == null ? null : Paths.get(drillHome, new String[0]);
            }
            catch (InvalidPathException e) {
                logger.warn("Unable to construct {} path [{}]: {}.", new Object[]{DRILL_HOME, drillHome, e.getMessage()});
                logger.debug("Invalid {} path", (Object)DRILL_HOME, (Object)e);
                return null;
            }
        }

        private boolean areShutdownArgsValid(Path drillHomePath, String gracefulFile) {
            StringBuilder builder = new StringBuilder();
            if (drillHomePath == null) {
                builder.append(DRILL_HOME).append(" is unset or invalid.");
            } else if (!Files.exists(drillHomePath, new LinkOption[0])) {
                builder.append(DRILL_HOME).append("path [").append(drillHomePath).append("] does not exist.");
            }
            if (gracefulFile == null) {
                if (builder.length() != 0) {
                    builder.append(" ");
                }
                builder.append(GRACEFUL_SIGFILE).append(" is unset.");
            }
            if (builder.length() != 0) {
                logger.warn("{}. {}", (Object)NOT_SUPPORTED_MESSAGE, (Object)builder.toString());
                return false;
            }
            return true;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private static final AtomicInteger idCounter = new AtomicInteger(0);
        private final Drillbit drillbit;
        private final StackTrace stackTrace;

        ShutdownThread(Drillbit drillbit, StackTrace stackTrace) {
            this.drillbit = drillbit;
            this.stackTrace = stackTrace;
            this.setName("Drillbit-ShutdownHook#" + idCounter.getAndIncrement());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (FailureUtils.hadUnrecoverableFailure()) {
                return;
            }
            logger.info("Received shutdown request.");
            try {
                AtomicInteger atomicInteger = idCounter;
                synchronized (atomicInteger) {
                    this.drillbit.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception closing Drillbit started from\n" + this.stackTrace, e);
            }
        }
    }
}

