/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.codahale.metrics.Counter;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.metrics.DrillMetrics;
import org.apache.drill.exec.rpc.AbstractRpcMetrics;
import org.apache.drill.exec.rpc.RpcMetrics;

public class UserRpcMetrics
extends AbstractRpcMetrics {
    private static final Counter encryptedConnections = DrillMetrics.getRegistry().counter("drill.connections.rpc.user.encrypted");
    private static final Counter unencryptedConnection = DrillMetrics.getRegistry().counter("drill.connections.rpc.user.unencrypted");
    private static final RpcMetrics INSTANCE = new UserRpcMetrics();

    private UserRpcMetrics() {
    }

    public static RpcMetrics getInstance() {
        return INSTANCE;
    }

    @Override
    public void initialize(boolean useEncryptedCounter, BufferAllocator allocator) {
        this.useEncryptedCounter = useEncryptedCounter;
        this.registerAllocatorMetrics(allocator);
    }

    @Override
    public void addConnectionCount() {
        if (this.useEncryptedCounter) {
            encryptedConnections.inc();
        } else {
            unencryptedConnection.inc();
        }
    }

    @Override
    public void decConnectionCount() {
        if (this.useEncryptedCounter) {
            encryptedConnections.dec();
        } else {
            unencryptedConnection.dec();
        }
    }

    @Override
    public long getEncryptedConnectionCount() {
        return encryptedConnections.getCount();
    }

    @Override
    public long getUnEncryptedConnectionCount() {
        return unencryptedConnection.getCount();
    }

    private void registerAllocatorMetrics(BufferAllocator allocator) {
        this.registerAllocatorMetrics(allocator, "drill.allocator.rpc.bit.user.");
    }
}

