/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.rpc.AbstractConnectionConfig;
import org.apache.drill.exec.rpc.RequestHandler;
import org.apache.drill.exec.rpc.security.AuthenticatorProvider;
import org.apache.drill.exec.rpc.user.InboundImpersonationManager;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.rpc.user.UserServerRequestHandler;
import org.apache.drill.exec.server.BootStrapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserConnectionConfig
extends AbstractConnectionConfig {
    private static final Logger logger = LoggerFactory.getLogger(UserConnectionConfig.class);
    private final boolean authEnabled;
    private final boolean sslEnabled;
    private final InboundImpersonationManager impersonationManager;
    private final UserServerRequestHandler handler;

    UserConnectionConfig(BufferAllocator allocator, BootStrapContext context, UserServerRequestHandler handler) throws DrillbitStartupException {
        super(allocator, context);
        this.handler = handler;
        DrillConfig config = context.getConfig();
        AuthenticatorProvider authProvider = this.getAuthProvider();
        if (config.getBoolean("drill.exec.security.user.auth.enabled")) {
            if (authProvider.getAllFactoryNames().isEmpty()) {
                throw new DrillbitStartupException("Authentication enabled, but no mechanisms found. Please check authentication configuration.");
            }
            this.authEnabled = true;
            this.encryptionContext.setEncryption(config.getBoolean("drill.exec.security.user.encryption.sasl.enabled"));
            int maxWrappedSize = config.getInt("drill.exec.security.user.encryption.sasl.max_wrapped_size");
            if (maxWrappedSize <= 0) {
                throw new DrillbitStartupException(String.format("Invalid value configured for user.encryption.sasl.max_wrapped_size. Must be a positive integer in bytes with a recommended max value of %s", 0xFFFFFF));
            }
            if (maxWrappedSize > 0xFFFFFF) {
                logger.warn("The configured value of user.encryption.sasl.max_wrapped_size: {} is too big. This may cause higher memory pressure. [Details: Recommended max value is {}]", (Object)maxWrappedSize, (Object)0xFFFFFF);
            }
            this.encryptionContext.setMaxWrappedSize(maxWrappedSize);
            logger.info("Configured all user connections to require authentication with encryption: {} using: {}", (Object)this.encryptionContext.getEncryptionCtxtString(), authProvider.getAllFactoryNames());
        } else {
            if (config.getBoolean("drill.exec.security.user.encryption.sasl.enabled")) {
                throw new DrillbitStartupException("Invalid security configuration. Encryption using SASL is enabled with authentication disabled. Please check the security.user configurations.");
            }
            this.authEnabled = false;
        }
        this.impersonationManager = config.getBoolean("drill.exec.impersonation.enabled") ? new InboundImpersonationManager() : null;
        this.sslEnabled = config.getBoolean("drill.exec.security.user.encryption.ssl.enabled");
        if (this.isSSLEnabled() && this.isAuthEnabled() && this.isEncryptionEnabled()) {
            logger.warn("The server is configured to use both SSL and SASL encryption (only one should be configured).");
        }
    }

    @Override
    public String getName() {
        return "user server";
    }

    boolean isAuthEnabled() {
        return this.authEnabled;
    }

    boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    InboundImpersonationManager getImpersonationManager() {
        return this.impersonationManager;
    }

    RequestHandler<UserServer.BitToUserConnection> getMessageHandler() {
        return this.handler;
    }
}

