/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.options.OptionMetaData;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.TypeValidators;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundImpersonationManager {
    private static final Logger logger = LoggerFactory.getLogger(InboundImpersonationManager.class);
    private static final String STAR = "*";
    private static final ObjectMapper impersonationPolicyMapper = JacksonUtils.createObjectMapper();
    private List<ImpersonationPolicy> impersonationPolicies;
    private String policiesString;

    private static List<ImpersonationPolicy> deserializeImpersonationPolicies(String impersonationPolicies) throws IOException {
        return (List)impersonationPolicyMapper.readValue(impersonationPolicies, (TypeReference)new TypeReference<List<ImpersonationPolicy>>(){});
    }

    private static boolean hasImpersonationPrivileges(String proxyName, String targetName, List<ImpersonationPolicy> policies) {
        UserGroupInformation proxyUgi = ImpersonationUtil.createProxyUgi(proxyName);
        HashSet<String> proxyGroups = Sets.newHashSet(proxyUgi.getGroupNames());
        UserGroupInformation targetUgi = ImpersonationUtil.createProxyUgi(targetName);
        HashSet<String> targetGroups = Sets.newHashSet(targetUgi.getGroupNames());
        for (ImpersonationPolicy definition : policies) {
            if (!definition.proxy_principals.users.contains(proxyName) && Sets.intersection(definition.proxy_principals.groups, proxyGroups).isEmpty() || !definition.target_principals.users.contains(targetName) && !definition.target_principals.users.contains(STAR) && Sets.intersection(definition.target_principals.groups, targetGroups).isEmpty() && !definition.target_principals.groups.contains(STAR)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static boolean hasImpersonationPrivileges(String proxyName, String targetName, String policiesString) throws IOException {
        return InboundImpersonationManager.hasImpersonationPrivileges(proxyName, targetName, InboundImpersonationManager.deserializeImpersonationPolicies(policiesString));
    }

    public void replaceUserOnSession(String targetName, UserSession session) {
        String proxyName;
        String policiesString = session.getOptions().getOption(ExecConstants.IMPERSONATION_POLICY_VALIDATOR);
        if (!policiesString.equals(this.policiesString)) {
            try {
                this.impersonationPolicies = InboundImpersonationManager.deserializeImpersonationPolicies(policiesString);
                this.policiesString = policiesString;
            }
            catch (IOException e) {
                logger.warn("Impersonation policies must have been validated.");
                throw new DrillRuntimeException("Failure while checking for impersonation policies.", e);
            }
        }
        if (!InboundImpersonationManager.hasImpersonationPrivileges(proxyName = session.getCredentials().getUserName(), targetName, this.impersonationPolicies)) {
            throw UserException.permissionError().message("Proxy user '%s' is not authorized to impersonate target user '%s'.", proxyName, targetName).build(logger);
        }
        UserBitShared.UserCredentials newCredentials = UserBitShared.UserCredentials.newBuilder().setUserName(targetName).build();
        session.replaceUserCredentials(this, newCredentials);
    }

    static {
        impersonationPolicyMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        impersonationPolicyMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    private static class ImpersonationPolicy {
        public UserGroupDefinition proxy_principals = new UserGroupDefinition();
        public UserGroupDefinition target_principals = new UserGroupDefinition();

        private ImpersonationPolicy() {
        }
    }

    private static class UserGroupDefinition {
        public Set<String> users = Sets.newHashSet();
        public Set<String> groups = Sets.newHashSet();

        private UserGroupDefinition() {
        }
    }

    public static class InboundImpersonationPolicyValidator
    extends TypeValidators.StringValidator {
        public InboundImpersonationPolicyValidator(String name) {
            super(name, null);
        }

        @Override
        public void validate(OptionValue v, OptionMetaData metaData, OptionSet manager) {
            List policies;
            super.validate(v, metaData, manager);
            try {
                policies = InboundImpersonationManager.deserializeImpersonationPolicies(v.string_val);
            }
            catch (IOException e) {
                throw UserException.validationError().message("Invalid impersonation policies.\nDetails: %s", e.getMessage()).build(logger);
            }
            for (ImpersonationPolicy policy : policies) {
                if (!policy.proxy_principals.users.contains(InboundImpersonationManager.STAR) && !policy.proxy_principals.groups.contains(InboundImpersonationManager.STAR)) continue;
                throw UserException.validationError().message("Proxy principals cannot have a wildcard entry.", new Object[0]).build(logger);
            }
        }
    }
}

