/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.rpc.data.AckSender;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class IncomingDataBatch {
    private final BitData.FragmentRecordBatch header;
    private final DrillBuf body;
    private final AckSender sender;

    public IncomingDataBatch(BitData.FragmentRecordBatch header, DrillBuf body, AckSender sender) {
        Preconditions.checkNotNull(header);
        Preconditions.checkNotNull(sender);
        this.header = header;
        this.body = body;
        this.sender = sender;
    }

    public RawFragmentBatch newRawFragmentBatch(BufferAllocator allocator) {
        DrillBuf transferredBuffer = this.body == null ? null : this.body.transferOwnership((BufferAllocator)allocator).buffer;
        this.sender.increment();
        return new RawFragmentBatch(this.header, transferredBuffer, this.sender);
    }

    public BitData.FragmentRecordBatch getHeader() {
        return this.header;
    }
}

