/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.channel.socket.SocketChannel;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.rpc.AbstractServerConnection;
import org.apache.drill.exec.rpc.data.DataConnectionConfig;
import org.apache.drill.exec.rpc.data.DataRpcMetrics;
import org.apache.drill.exec.rpc.security.ServerAuthenticationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServerConnection
extends AbstractServerConnection<DataServerConnection> {
    private static final Logger logger = LoggerFactory.getLogger(DataServerConnection.class);

    DataServerConnection(SocketChannel channel, DataConnectionConfig config) {
        super(channel, config, config.getAuthMechanismToUse() == null ? config.getMessageHandler() : new ServerAuthenticationHandler<DataServerConnection, BitData.RpcType>(config.getMessageHandler(), 4, BitData.RpcType.SASL_MESSAGE));
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public void incConnectionCounter() {
        DataRpcMetrics.getInstance().addConnectionCount();
    }

    @Override
    public void decConnectionCounter() {
        DataRpcMetrics.getInstance().decConnectionCount();
    }
}

