/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.codahale.metrics.Counter;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.metrics.DrillMetrics;
import org.apache.drill.exec.rpc.AbstractRpcMetrics;
import org.apache.drill.exec.rpc.RpcMetrics;

public class DataRpcMetrics
extends AbstractRpcMetrics {
    private static final Counter encryptedConnections = DrillMetrics.getRegistry().counter("drill.connections.rpc.data.encrypted");
    private static final Counter unencryptedConnection = DrillMetrics.getRegistry().counter("drill.connections.rpc.data.unencrypted");
    private static final RpcMetrics INSTANCE = new DataRpcMetrics();

    private DataRpcMetrics() {
    }

    public static RpcMetrics getInstance() {
        return INSTANCE;
    }

    @Override
    public void initialize(boolean useEncryptedCounter, BufferAllocator allocator) {
        this.useEncryptedCounter = useEncryptedCounter;
        this.registerAllocatorMetrics(allocator);
    }

    @Override
    public void addConnectionCount() {
        if (this.useEncryptedCounter) {
            encryptedConnections.inc();
        } else {
            unencryptedConnection.inc();
        }
    }

    @Override
    public void decConnectionCount() {
        if (this.useEncryptedCounter) {
            encryptedConnections.dec();
        } else {
            unencryptedConnection.dec();
        }
    }

    @Override
    public long getEncryptedConnectionCount() {
        return encryptedConnections.getCount();
    }

    @Override
    public long getUnEncryptedConnectionCount() {
        return unencryptedConnection.getCount();
    }

    private void registerAllocatorMetrics(BufferAllocator allocator) {
        this.registerAllocatorMetrics(allocator, "drill.allocator.rpc.bit.data.");
    }
}

