/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.data.DataClient;
import org.apache.drill.exec.rpc.data.DataClientConnection;
import org.apache.drill.exec.rpc.data.DataConnectionConfig;
import org.apache.drill.exec.rpc.data.DataRpcConfig;

public class DataConnectionManager
extends ReconnectingConnection<DataClientConnection, BitData.BitClientHandshake> {
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;
    private final DataConnectionConfig config;
    private static final BitData.BitClientHandshake HANDSHAKE = BitData.BitClientHandshake.newBuilder().setRpcVersion(DataRpcConfig.RPC_VERSION).setChannel(UserBitShared.RpcChannel.BIT_DATA).build();

    public DataConnectionManager(CoordinationProtos.DrillbitEndpoint remoteEndpoint, DataConnectionConfig config) {
        super(HANDSHAKE, remoteEndpoint.getAddress(), remoteEndpoint.getDataPort());
        this.remoteEndpoint = remoteEndpoint;
        this.config = config;
    }

    protected DataClient getNewClient() {
        return new DataClient(this.remoteEndpoint, this.config, new ReconnectingConnection.CloseHandlerCreator());
    }
}

