/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.BitRpcUtility;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataClientConnection;
import org.apache.drill.exec.rpc.data.DataConnectionConfig;
import org.apache.drill.exec.rpc.data.DataDefaultInstanceHandler;
import org.apache.drill.exec.rpc.data.DataProtobufLengthDecoder;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClient
extends BasicClient<BitData.RpcType, DataClientConnection, BitData.BitClientHandshake, BitData.BitServerHandshake> {
    private static final Logger logger = LoggerFactory.getLogger(DataClient.class);
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;
    private volatile DataClientConnection connection;
    private final ReconnectingConnection.CloseHandlerCreator closeHandlerFactory;
    private final DataConnectionConfig config;

    public DataClient(CoordinationProtos.DrillbitEndpoint remoteEndpoint, DataConnectionConfig config, ReconnectingConnection.CloseHandlerCreator closeHandlerFactory) {
        super(DataRpcConfig.getMapping(config.getBootstrapContext().getConfig(), config.getBootstrapContext().getExecutor()), config.getAllocator().getAsByteBufAllocator(), config.getBootstrapContext().getDataClientLoopGroup(), BitData.RpcType.HANDSHAKE, BitData.BitServerHandshake.class, BitData.BitServerHandshake.PARSER);
        this.remoteEndpoint = remoteEndpoint;
        this.config = config;
        this.closeHandlerFactory = closeHandlerFactory;
    }

    @Override
    protected DataClientConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        this.connection = new DataClientConnection(channel, this, this.config.getEncryptionCtxt());
        this.connection.incConnectionCounter();
        return this.connection;
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel ch, DataClientConnection clientConnection) {
        return this.closeHandlerFactory.getHandler(clientConnection, super.getCloseHandler(ch, clientConnection));
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DataDefaultInstanceHandler.getResponseDefaultInstanceClient(rpcType);
    }

    @Override
    protected void handle(DataClientConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        throw new UnsupportedOperationException("DataClient is unidirectional by design.");
    }

    BufferAllocator getAllocator() {
        return this.config.getAllocator();
    }

    @Override
    protected void prepareSaslHandshake(RpcConnectionHandler<DataClientConnection> connectionHandler, List<String> serverAuthMechanisms) {
        BitRpcUtility.prepareSaslHandshake(connectionHandler, serverAuthMechanisms, this.connection, this.config, this.remoteEndpoint, this, BitData.RpcType.SASL_MESSAGE);
    }

    @Override
    protected List<String> validateHandshake(BitData.BitServerHandshake handshake) throws RpcException {
        return BitRpcUtility.validateHandshake(handshake.getRpcVersion(), handshake.getAuthenticationMechanismsList(), DataRpcConfig.RPC_VERSION, this.connection, this.config, this);
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new DataProtobufLengthDecoder.Client(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

