/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WorkEventBus.class);
    private final ConcurrentMap<ExecProtos.FragmentHandle, FragmentManager> managers = Maps.newConcurrentMap();
    private final ConcurrentMap<UserBitShared.QueryId, FragmentStatusListener> listeners = new ConcurrentHashMap<UserBitShared.QueryId, FragmentStatusListener>(16, 0.75f, 16);

    public void removeFragmentStatusListener(UserBitShared.QueryId queryId) {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing fragment status listener for queryId {}.", (Object)QueryIdHelper.getQueryId(queryId));
        }
        this.listeners.remove(queryId);
    }

    public void addFragmentStatusListener(UserBitShared.QueryId queryId, FragmentStatusListener listener) throws ForemanSetupException {
        FragmentStatusListener old;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding fragment status listener for queryId {}.", (Object)QueryIdHelper.getQueryId(queryId));
        }
        if ((old = this.listeners.putIfAbsent(queryId, listener)) != null) {
            throw new ForemanSetupException("Failure.  The provided handle already exists in the listener pool.  You need to remove one listener before adding another.");
        }
    }

    public void statusUpdate(BitControl.FragmentStatus status) {
        FragmentStatusListener listener = (FragmentStatusListener)this.listeners.get(status.getHandle().getQueryId());
        if (listener == null) {
            logger.warn("A fragment message arrived but there was no registered listener for that message: {}.", (Object)status);
        } else {
            listener.statusUpdate(status);
        }
    }

    public void addFragmentManager(FragmentManager fragmentManager) {
        FragmentManager old;
        if (logger.isDebugEnabled()) {
            logger.debug("Fragment {} manager created: {}", (Object)QueryIdHelper.getQueryIdentifier(fragmentManager.getHandle()), (Object)fragmentManager);
        }
        if ((old = this.managers.putIfAbsent(fragmentManager.getHandle(), fragmentManager)) != null) {
            throw new IllegalStateException(String.format("Manager %s for fragment %s already exists.", old, QueryIdHelper.getQueryIdentifier(fragmentManager.getHandle())));
        }
    }

    public FragmentManager getFragmentManager(ExecProtos.FragmentHandle handle) {
        return (FragmentManager)this.managers.get(handle);
    }

    public boolean removeFragmentManager(ExecProtos.FragmentHandle handle, boolean cancel) {
        FragmentManager manager = (FragmentManager)this.managers.remove(handle);
        if (manager != null) {
            assert (!manager.isCancelled()) : String.format("Fragment %s manager %s is already cancelled.", QueryIdHelper.getQueryIdentifier(handle), manager);
            if (cancel) {
                manager.cancel();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} fragment {} manager {} from the work bus.", new Object[]{cancel ? "Cancel and removed" : "Removed", QueryIdHelper.getQueryIdentifier(handle), manager});
            }
            return true;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Fragment {} manager is not found in the work bus.", (Object)QueryIdHelper.getQueryIdentifier(handle));
        }
        return false;
    }
}

