/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.control.ControlClient;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlConnectionConfig;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteControlConnectionManager
extends ControlConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteControlConnectionManager.class);
    private final ControlConnectionConfig config;
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;

    public RemoteControlConnectionManager(ControlConnectionConfig config, CoordinationProtos.DrillbitEndpoint localEndpoint, CoordinationProtos.DrillbitEndpoint remoteEndpoint) {
        super(localEndpoint, remoteEndpoint);
        this.config = config;
        this.remoteEndpoint = remoteEndpoint;
    }

    @Override
    protected BasicClient<?, ControlConnection, BitControl.BitControlHandshake, ?> getNewClient() {
        return new ControlClient(this.config, this.remoteEndpoint, new ReconnectingConnection.CloseHandlerCreator());
    }
}

