/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.BitRpcUtility;
import org.apache.drill.exec.rpc.FailingRequestHandler;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlConnectionConfig;
import org.apache.drill.exec.rpc.control.ControlProtobufLengthDecoder;
import org.apache.drill.exec.rpc.control.ControlRpcConfig;
import org.apache.drill.exec.rpc.control.DefaultInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlClient
extends BasicClient<BitControl.RpcType, ControlConnection, BitControl.BitControlHandshake, BitControl.BitControlHandshake> {
    private static final Logger logger = LoggerFactory.getLogger(ControlClient.class);
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;
    private volatile ControlConnection connection;
    private final ReconnectingConnection.CloseHandlerCreator closeHandlerFactory;
    private final ControlConnectionConfig config;

    public ControlClient(ControlConnectionConfig config, CoordinationProtos.DrillbitEndpoint remoteEndpoint, ReconnectingConnection.CloseHandlerCreator closeHandlerFactory) {
        super(ControlRpcConfig.getMapping(config.getBootstrapContext().getConfig(), config.getBootstrapContext().getExecutor()), config.getAllocator().getAsByteBufAllocator(), config.getBootstrapContext().getControlLoopGroup(), BitControl.RpcType.HANDSHAKE, BitControl.BitControlHandshake.class, BitControl.BitControlHandshake.PARSER);
        this.config = config;
        this.remoteEndpoint = remoteEndpoint;
        this.closeHandlerFactory = closeHandlerFactory;
    }

    @Override
    protected ControlConnection initRemoteConnection(SocketChannel channel) {
        super.initRemoteConnection(channel);
        this.connection = new ControlConnection(channel, "control client", this.config, this.config.getAuthMechanismToUse() == null ? this.config.getMessageHandler() : new FailingRequestHandler(), this);
        this.connection.incConnectionCounter();
        return this.connection;
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(SocketChannel ch, ControlConnection clientConnection) {
        return this.closeHandlerFactory.getHandler(clientConnection, super.getCloseHandler(ch, clientConnection));
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DefaultInstanceHandler.getResponseDefaultInstance(rpcType);
    }

    @Override
    protected void handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        connection.getCurrentHandler().handle(connection, rpcType, pBody, dBody, sender);
    }

    @Override
    protected void prepareSaslHandshake(RpcConnectionHandler<ControlConnection> connectionHandler, List<String> serverAuthMechanisms) {
        BitRpcUtility.prepareSaslHandshake(connectionHandler, serverAuthMechanisms, this.connection, this.config, this.remoteEndpoint, this, BitControl.RpcType.SASL_MESSAGE);
    }

    @Override
    protected List<String> validateHandshake(BitControl.BitControlHandshake handshake) throws RpcException {
        return BitRpcUtility.validateHandshake(handshake.getRpcVersion(), handshake.getAuthenticationMechanismsList(), 3, this.connection, this.config, this);
    }

    @Override
    protected void finalizeConnection(BitControl.BitControlHandshake handshake, ControlConnection connection) {
        connection.setEndpoint(handshake.getEndpoint());
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new ControlProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

