/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.SaslCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaslEncryptionHandler
extends MessageToMessageEncoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger((String)SaslEncryptionHandler.class.getCanonicalName());
    private final SaslCodec saslCodec;
    private final int wrapSizeLimit;
    private byte[] origMsgBuffer;
    private final ByteBuffer lengthOctets;
    private final OutOfMemoryHandler outOfMemoryHandler;

    SaslEncryptionHandler(SaslCodec saslCodec, int wrapSizeLimit, OutOfMemoryHandler oomHandler) {
        this.saslCodec = saslCodec;
        this.wrapSizeLimit = wrapSizeLimit;
        this.outOfMemoryHandler = oomHandler;
        this.origMsgBuffer = new byte[this.wrapSizeLimit];
        this.lengthOctets = ByteBuffer.allocate(4);
        this.lengthOctets.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        logger.trace("Added sasl-encryption-handler handler!");
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        logger.trace("Removed sasl-encryption-handler handler");
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws IOException {
        if (!ctx.channel().isOpen()) {
            logger.debug("In sasl-encryption-handler and channel is not open. So releasing msg memory before encryption.");
            msg.release();
            return;
        }
        try {
            assert (msg instanceof CompositeByteBuf);
            CompositeByteBuf cbb = (CompositeByteBuf)msg;
            int numComponents = cbb.numComponents();
            for (int currentIndex = 0; currentIndex < numComponents; ++currentIndex) {
                ByteBuf component = cbb.component(currentIndex);
                if (component.readableBytes() > this.wrapSizeLimit) {
                    throw new RpcException(String.format("Component Chunk size: %d is greater than the wrapSizeLimit: %d", component.readableBytes(), this.wrapSizeLimit));
                }
                byte[] origMsg = this.origMsgBuffer;
                component.getBytes(component.readerIndex(), origMsg, 0, component.readableBytes());
                if (logger.isTraceEnabled()) {
                    logger.trace("Trying to encrypt chunk of size:{} with wrapSizeLimit:{}", (Object)component.readableBytes(), (Object)this.wrapSizeLimit);
                }
                byte[] wrappedMsg = this.saslCodec.wrap(origMsg, 0, component.readableBytes());
                if (logger.isTraceEnabled()) {
                    logger.trace("Successfully encrypted message, original size: {} Final Size: {}", (Object)component.readableBytes(), (Object)wrappedMsg.length);
                }
                ByteBuf encryptedBuf = ctx.alloc().buffer(wrappedMsg.length + 4);
                this.lengthOctets.putInt(wrappedMsg.length);
                encryptedBuf.writeBytes(this.lengthOctets.array());
                this.lengthOctets.rewind();
                encryptedBuf.writeBytes(wrappedMsg);
                msg.skipBytes(component.readableBytes());
                component.skipBytes(component.readableBytes());
                out.add(encryptedBuf);
            }
        }
        catch (OutOfMemoryException e) {
            logger.warn("Failure allocating buffer on incoming stream due to memory limits.");
            msg.resetReaderIndex();
            this.outOfMemoryHandler.handle();
        }
        catch (IOException e) {
            logger.error("Something went wrong while wrapping the message: {} with MaxRawWrapSize: {}, and error: {}", new Object[]{msg, this.wrapSizeLimit, e.getMessage()});
            throw e;
        }
    }
}

