/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChunkCreationHandler
extends MessageToMessageEncoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger((String)ChunkCreationHandler.class.getCanonicalName());
    private final int chunkSize;

    ChunkCreationHandler(int chunkSize) {
        Preconditions.checkArgument(chunkSize > 0);
        this.chunkSize = chunkSize;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        logger.trace("Added chunk-creation-handler handler!");
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        logger.trace("Removed chunk-creation-handler handler");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int numChunks;
        if (!ctx.channel().isOpen()) {
            logger.debug("Channel closed, skipping encode inside {}.", (Object)"chunk-creation-handler");
            msg.release();
            return;
        }
        CompositeByteBuf cbb = ctx.alloc().compositeBuffer(numChunks);
        int cbbWriteIndex = 0;
        int currentChunkLen = Math.min(msg.readableBytes(), this.chunkSize);
        for (numChunks = (int)Math.ceil((double)msg.readableBytes() / (double)this.chunkSize); numChunks > 0; --numChunks) {
            ByteBuf chunkBuf = msg.slice(msg.readerIndex(), currentChunkLen);
            chunkBuf.retain();
            cbb.addComponent(chunkBuf);
            cbbWriteIndex += currentChunkLen;
            msg.skipBytes(currentChunkLen);
            currentChunkLen = Math.min(msg.readableBytes(), this.chunkSize);
        }
        cbb.writerIndex(cbbWriteIndex);
        out.add(cbb);
    }
}

