/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.channel.socket.SocketChannel;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.drill.exec.rpc.AbstractRemoteConnection;
import org.apache.drill.exec.rpc.ClientConnection;
import org.apache.drill.exec.rpc.EncryptionContext;
import org.apache.drill.exec.rpc.EncryptionContextImpl;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.SaslCodec;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;

public abstract class AbstractClientConnection
extends AbstractRemoteConnection
implements ClientConnection {
    private SaslClient saslClient;

    public AbstractClientConnection(SocketChannel channel, String name, EncryptionContext encryptContext) {
        super(channel, name, encryptContext);
    }

    public AbstractClientConnection(SocketChannel channel, String name) {
        this(channel, name, new EncryptionContextImpl());
    }

    protected abstract Logger getLogger();

    @Override
    public void setSaslClient(final SaslClient saslClient) {
        Preconditions.checkState(this.saslClient == null);
        this.saslClient = saslClient;
        if (this.isEncryptionEnabled()) {
            this.saslCodec = new SaslCodec(){

                @Override
                public byte[] wrap(byte[] data, int offset, int len) throws SaslException {
                    Preconditions.checkState(saslClient != null);
                    return saslClient.wrap(data, offset, len);
                }

                @Override
                public byte[] unwrap(byte[] data, int offset, int len) throws SaslException {
                    Preconditions.checkState(saslClient != null);
                    return saslClient.unwrap(data, offset, len);
                }
            };
        }
    }

    @Override
    public SaslClient getSaslClient() {
        Preconditions.checkState(this.saslClient != null);
        return this.saslClient;
    }

    @Override
    public void disposeSaslClient() {
        try {
            if (this.saslClient != null) {
                this.saslClient.dispose();
                this.saslClient = null;
            }
        }
        catch (SaslException e) {
            this.getLogger().warn("Unclean disposal", (Throwable)e);
        }
    }

    @Override
    public void channelClosed(RpcException ex) {
        this.disposeSaslClient();
        this.decConnectionCounter();
        super.channelClosed(ex);
    }
}

