/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.config.selectors;

import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import org.apache.drill.exec.resourcemgr.config.selectors.AbstractResourcePoolSelector;
import org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelector;
import org.apache.drill.exec.resourcemgr.config.selectors.ResourcePoolSelectorFactory;

public abstract class ComplexSelectors
extends AbstractResourcePoolSelector {
    protected final List<ResourcePoolSelector> childSelectors = new ArrayList<ResourcePoolSelector>();

    ComplexSelectors(ResourcePoolSelector.SelectorType type, List<? extends Config> selectorConfig) throws RMConfigException {
        super(type);
        this.parseAndCreateChildSelectors(selectorConfig);
    }

    private void parseAndCreateChildSelectors(List<? extends Config> childConfigs) throws RMConfigException {
        for (Config config : childConfigs) {
            this.childSelectors.add(ResourcePoolSelectorFactory.createSelector(config));
        }
        if (this.childSelectors.size() < 2) {
            throw new RMConfigException(String.format("For complex selector OR and AND it is expected to have atleast 2 selectors in the list but found %d", this.childSelectors.size()));
        }
    }

    @Override
    public abstract boolean isQuerySelected(QueryContext var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ SelectorType: ").append(super.toString());
        sb.append(", of selectors [");
        for (ResourcePoolSelector childSelector : this.childSelectors) {
            sb.append(childSelector.toString()).append(", ");
        }
        sb.append("]}");
        return sb.toString();
    }
}

