/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resourcemgr.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.resourcemgr.config.ResourcePool;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueAssignmentResult {
    private static final Logger logger = LoggerFactory.getLogger(QueueAssignmentResult.class);
    private final List<ResourcePool> selectedLeafPools = new ArrayList<ResourcePool>();
    private final List<ResourcePool> rejectedPools = new ArrayList<ResourcePool>();

    public void addSelectedPool(ResourcePool pool) {
        Preconditions.checkState(pool.isLeafPool(), "Selected pool %s is not a leaf pool", (Object)pool.getPoolName());
        this.selectedLeafPools.add(pool);
    }

    public void addRejectedPool(ResourcePool pool) {
        this.rejectedPools.add(pool);
    }

    public List<ResourcePool> getSelectedLeafPools() {
        return this.selectedLeafPools;
    }

    public List<ResourcePool> getRejectedPools() {
        return this.rejectedPools;
    }

    public void logAssignmentResult(String queryId) {
        logger.debug("For query {}. Details[{}]", (Object)queryId, (Object)this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected Leaf Pools: {");
        for (ResourcePool pool : this.selectedLeafPools) {
            sb.append(pool.getPoolName()).append(", ");
        }
        sb.append("} and Rejected pools: {");
        for (ResourcePool pool : this.rejectedPools) {
            sb.append(pool.getPoolName()).append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

