/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resolver;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionResolver
implements FunctionResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFunctionResolver.class);

    @Override
    public DrillFuncHolder getBestMatch(List<DrillFuncHolder> methods, FunctionCall call) {
        float bestCost = Float.POSITIVE_INFINITY;
        float currCost = Float.POSITIVE_INFINITY;
        DrillFuncHolder bestMatch = null;
        LinkedList<DrillFuncHolder> bestMatchAlternatives = new LinkedList<DrillFuncHolder>();
        List<TypeProtos.MajorType> argumentTypes = call.args().stream().map(LogicalExpression::getMajorType).collect(Collectors.toList());
        for (DrillFuncHolder h : methods) {
            currCost = TypeCastRules.getCost(argumentTypes, h);
            if (currCost < bestCost) {
                bestCost = currCost;
                bestMatch = h;
                bestMatchAlternatives.clear();
                continue;
            }
            if (currCost != bestCost || !(currCost < Float.POSITIVE_INFINITY)) continue;
            bestMatchAlternatives.add(h);
        }
        if (bestCost == Float.POSITIVE_INFINITY) {
            return null;
        }
        if (bestMatchAlternatives.size() > 0) {
            logger.info("Multiple functions with best cost found, query processing will be aborted.");
            logger.debug("Printing all the possible functions that could have matched: ");
            for (DrillFuncHolder holder : bestMatchAlternatives) {
                logger.debug(holder.toString());
            }
            throw UserException.functionError().message("There are %d function definitions with the same casting cost for %s, please write explicit casts disambiguate your function call.", 1 + bestMatchAlternatives.size(), call).build(logger);
        }
        return bestMatch;
    }
}

