/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.selection;

import io.netty.buffer.ByteBuf;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.DeadBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionVector4
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(SelectionVector4.class);
    private ByteBuf data;
    private int recordCount;
    private int start;
    private int length;

    public SelectionVector4(ByteBuf vector, int recordCount, int batchRecordCount) {
        if (recordCount > 0x1FFFFFFF) {
            throw UserException.internalError(null).message(String.format("Currently, Drill can only support allocations up to 2gb in size. Query requested an allocation of %d bytes.", (long)recordCount * 4L), new Object[0]).build(logger);
        }
        this.recordCount = recordCount;
        this.start = 0;
        this.length = Math.min(batchRecordCount, recordCount);
        this.data = vector;
    }

    public SelectionVector4(BufferAllocator allocator, int recordCount) {
        if (recordCount > 0x1FFFFFFF) {
            throw UserException.internalError(null).message(String.format("Currently, Drill can only support allocations up to 2gb in size. Query requested an allocation of %d bytes.", (long)recordCount * 4L), new Object[0]).build(logger);
        }
        this.recordCount = recordCount;
        this.start = 0;
        this.length = recordCount;
        this.data = allocator.buffer(recordCount * 4);
    }

    public int getTotalCount() {
        return this.recordCount;
    }

    public int getCount() {
        return this.length;
    }

    private ByteBuf getData() {
        return this.data;
    }

    public void setCount(int length) {
        this.length = length;
        this.recordCount = length;
    }

    public void set(int index, int compound) {
        this.data.setInt(index * 4, compound);
    }

    public void set(int index, int recordBatch, int recordIndex) {
        this.data.setInt(index * 4, recordBatch << 16 | recordIndex & 0xFFFF);
    }

    public int get(int index) {
        return this.data.getInt((this.start + index) * 4);
    }

    public SelectionVector4 createNewWrapperCurrent(int batchRecordCount) {
        this.data.retain();
        SelectionVector4 sv4 = new SelectionVector4(this.data, this.recordCount, batchRecordCount);
        sv4.start = this.start;
        return sv4;
    }

    public SelectionVector4 createNewWrapperCurrent() {
        return this.createNewWrapperCurrent(this.length);
    }

    public boolean next() {
        if (!this.hasNext()) {
            this.start = this.recordCount;
            this.length = 0;
            return false;
        }
        this.start += this.length;
        int newEnd = Math.min(this.start + this.length, this.recordCount);
        this.length = newEnd - this.start;
        return true;
    }

    public boolean hasNext() {
        int endIndex = this.start + this.length;
        return endIndex < this.recordCount;
    }

    public void clear() {
        this.start = 0;
        this.length = 0;
        this.recordCount = 0;
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.release();
            this.data = DeadBuf.DEAD_BUFFER;
        }
    }

    public void copy(SelectionVector4 fromSV4) {
        this.clear();
        this.recordCount = fromSV4.getTotalCount();
        this.length = fromSV4.getCount();
        this.data = fromSV4.getData();
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.retain();
        }
    }

    public static int getBatchIndex(int sv4Index) {
        return sv4Index >> 16 & 0xFFFF;
    }

    public static int getRecordIndex(int sv4Index) {
        return sv4Index & 0xFFFF;
    }

    @Override
    public void close() {
        this.clear();
    }

    public String toString() {
        return "SelectionVector4[data=" + this.data + ", recordCount=" + this.recordCount + ", start=" + this.start + ", length=" + this.length + "]";
    }
}

