/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema.parser;

import java.io.IOException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaLexer;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaParser;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaParsingException;
import org.apache.drill.exec.record.metadata.schema.parser.SchemaVisitor;
import org.apache.drill.exec.record.metadata.schema.parser.UpperCaseCharStream;

public class SchemaExprParser {
    public static TupleMetadata parseSchema(String schema) throws IOException {
        SchemaVisitor visitor = new SchemaVisitor();
        try {
            return (TupleMetadata)visitor.visit((ParseTree)SchemaExprParser.initParser(schema).schema());
        }
        catch (SchemaParsingException e) {
            throw new IOException(String.format("Unable to parse schema [%s]: %s", schema, e.getMessage()), e);
        }
    }

    public static ColumnMetadata parseColumn(String name, String type, TypeProtos.DataMode mode) throws IOException {
        return SchemaExprParser.parseColumn(String.format("`%s` %s %s", name.replaceAll("(\\\\)|(`)", "\\\\$0"), type, TypeProtos.DataMode.REQUIRED == mode ? "not null" : ""));
    }

    public static ColumnMetadata parseColumn(String column) throws IOException {
        SchemaVisitor.ColumnVisitor visitor = new SchemaVisitor.ColumnVisitor();
        try {
            return (ColumnMetadata)visitor.visit((ParseTree)SchemaExprParser.initParser(column).column());
        }
        catch (SchemaParsingException e) {
            throw new IOException(String.format("Unable to parse column [%s]: %s", column, e.getMessage()), e);
        }
    }

    private static SchemaParser initParser(String value) {
        CodePointCharStream stream = CharStreams.fromString((String)value);
        UpperCaseCharStream upperCaseStream = new UpperCaseCharStream((CharStream)stream);
        SchemaLexer lexer = new SchemaLexer(upperCaseStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SchemaParser parser = new SchemaParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ErrorListener.INSTANCE);
        return parser;
    }

    private static class ErrorListener
    extends BaseErrorListener {
        static final ErrorListener INSTANCE = new ErrorListener();

        private ErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            StringBuilder builder = new StringBuilder();
            builder.append("Line [").append(line).append("]");
            builder.append(", position [").append(charPositionInLine).append("]");
            if (offendingSymbol != null) {
                builder.append(", offending symbol ").append(offendingSymbol);
            }
            if (msg != null) {
                builder.append(": ").append(msg);
            }
            throw new SchemaParsingException(builder.toString());
        }
    }
}

