/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata.schema;

import org.apache.drill.exec.store.StorageStrategy;

public class StorageProperties {
    private final StorageStrategy storageStrategy;
    private final boolean overwrite;

    private StorageProperties(Builder builder) {
        this.storageStrategy = builder.storageStrategy;
        this.overwrite = builder.overwrite;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public static class Builder {
        private StorageStrategy storageStrategy = StorageStrategy.DEFAULT;
        private boolean overwrite;

        public Builder storageStrategy(StorageStrategy storageStrategy) {
            this.storageStrategy = storageStrategy;
            return this;
        }

        public Builder overwrite() {
            this.overwrite = true;
            return this;
        }

        public Builder overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public StorageProperties build() {
            return new StorageProperties(this);
        }
    }
}

