/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;

public class VariantColumnMetadata
extends AbstractColumnMetadata {
    private final VariantSchema variantSchema;

    public VariantColumnMetadata(MaterializedField schema) {
        super(schema);
        List<TypeProtos.MinorType> types;
        this.variantSchema = new VariantSchema();
        this.variantSchema.bind(this);
        if (this.type() == TypeProtos.MinorType.UNION) {
            types = schema.getType().getSubTypeList();
        } else {
            TypeProtos.MinorType childType;
            MaterializedField child;
            assert (this.type() == TypeProtos.MinorType.LIST);
            if (schema.getChildren().isEmpty()) {
                child = null;
                childType = TypeProtos.MinorType.LATE;
            } else {
                child = schema.getChildren().iterator().next();
                childType = child.getType().getMinorType();
            }
            switch (childType) {
                case UNION: {
                    types = child.getType().getSubTypeList();
                    break;
                }
                case LATE: {
                    return;
                }
                default: {
                    this.variantSchema.addType(MetadataUtils.fromField(child));
                    return;
                }
            }
        }
        if (types == null) {
            return;
        }
        for (TypeProtos.MinorType type : types) {
            this.variantSchema.addType(type);
        }
    }

    public VariantColumnMetadata(MaterializedField schema, VariantSchema variantSchema) {
        super(schema);
        this.variantSchema = variantSchema;
    }

    private VariantColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, VariantSchema variantSchema) {
        super(name, type, mode);
        this.variantSchema = variantSchema;
        this.variantSchema.bind(this);
    }

    public static VariantColumnMetadata union(String name) {
        return VariantColumnMetadata.unionOf(name, null);
    }

    public static VariantColumnMetadata unionOf(String name, VariantSchema variantSchema) {
        return new VariantColumnMetadata(name, TypeProtos.MinorType.UNION, TypeProtos.DataMode.OPTIONAL, VariantColumnMetadata.variantSchemaFor(variantSchema));
    }

    public static VariantColumnMetadata unionOf(MaterializedField schema, VariantSchema variantSchema) {
        return new VariantColumnMetadata(schema, VariantColumnMetadata.variantSchemaFor(variantSchema));
    }

    public static VariantColumnMetadata list(String name) {
        return new VariantColumnMetadata(name, TypeProtos.MinorType.LIST, TypeProtos.DataMode.OPTIONAL, new VariantSchema());
    }

    public static VariantColumnMetadata listOf(String name, VariantSchema variantSchema) {
        return new VariantColumnMetadata(name, TypeProtos.MinorType.LIST, TypeProtos.DataMode.OPTIONAL, VariantColumnMetadata.variantSchemaFor(variantSchema));
    }

    public static VariantColumnMetadata variantOf(String name, TypeProtos.MinorType type, VariantSchema variantSchema) {
        switch (type) {
            case UNION: {
                return VariantColumnMetadata.unionOf(name, variantSchema);
            }
            case LIST: {
                return VariantColumnMetadata.listOf(name, variantSchema);
            }
        }
        throw new IllegalArgumentException(type.name());
    }

    private static VariantSchema variantSchemaFor(VariantSchema variantSchema) {
        return variantSchema == null ? new VariantSchema() : variantSchema;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.VARIANT;
    }

    @Override
    public boolean isVariant() {
        return true;
    }

    @Override
    public boolean isArray() {
        return super.isArray() || this.type() == TypeProtos.MinorType.LIST;
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        VariantColumnMetadata colMeta = new VariantColumnMetadata(this.name, this.type, this.mode, new VariantSchema());
        colMeta.setProperties(this.properties());
        return colMeta;
    }

    @Override
    public ColumnMetadata copy() {
        return new VariantColumnMetadata(this.name, this.type, this.mode, this.variantSchema.copy());
    }

    @Override
    public VariantMetadata variantSchema() {
        return this.variantSchema;
    }

    @Override
    public String typeString() {
        StringBuilder builder = new StringBuilder();
        if (this.isArray()) {
            builder.append("ARRAY<");
        }
        builder.append("UNION");
        if (this.isArray()) {
            builder.append(">");
        }
        return builder.toString();
    }

    @Override
    public MaterializedField schema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(TypeProtos.DataMode.OPTIONAL).addAllSubType(this.variantSchema.types()).build());
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(TypeProtos.DataMode.OPTIONAL).build());
    }

    @Override
    protected void appendContents(StringBuilder buf) {
        buf.append(", variant: ").append(this.variantSchema().toString());
    }

    @Override
    public boolean isEquivalent(ColumnMetadata o) {
        if (!super.isEquivalent(o)) {
            return false;
        }
        VariantColumnMetadata other = (VariantColumnMetadata)o;
        return this.variantSchema.isEquivalent(other.variantSchema);
    }
}

