/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.Propertied;
import org.apache.drill.exec.record.metadata.TupleSchema;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=TupleSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=TupleSchema.class, name="tuple_schema")})
public interface TupleMetadata
extends Propertied,
Iterable<ColumnMetadata> {
    public static final ObjectWriter WRITER = JacksonUtils.createObjectMapper().writerFor(TupleMetadata.class);
    public static final ObjectReader READER = JacksonUtils.createObjectMapper().readerFor(TupleMetadata.class);
    public static final String IS_STRICT_SCHEMA_PROP = "drill.strict";

    public ColumnMetadata add(MaterializedField var1);

    public int addColumn(ColumnMetadata var1);

    public int size();

    public boolean isEmpty();

    public int index(String var1);

    public ColumnMetadata metadata(int var1);

    public ColumnMetadata metadata(String var1);

    public MaterializedField column(int var1);

    public MaterializedField column(String var1);

    public boolean isEquivalent(TupleMetadata var1);

    public ColumnMetadata parent();

    public List<MaterializedField> toFieldList();

    public List<ColumnMetadata> toMetadataList();

    public String fullName(ColumnMetadata var1);

    public String fullName(int var1);

    public TupleMetadata copy();

    public void replace(ColumnMetadata var1);

    default public String jsonString() {
        try {
            return WRITER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert tuple metadata into JSON string: " + this.toString(), e);
        }
    }

    public static TupleMetadata of(String jsonString) {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        try {
            return (TupleMetadata)READER.readValue(jsonString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to deserialize given JSON string into tuple metadata: " + jsonString, e);
        }
    }
}

