/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class RepeatedListColumnMetadata
extends AbstractColumnMetadata {
    public static final int UNKNOWN_DIMENSIONS = -1;
    private ColumnMetadata childSchema;

    public RepeatedListColumnMetadata(MaterializedField field) {
        super(field);
        Preconditions.checkArgument(field.getType().getMinorType() == TypeProtos.MinorType.LIST);
        Preconditions.checkArgument(field.getType().getMode() == TypeProtos.DataMode.REPEATED);
        Preconditions.checkArgument(field.getChildren().size() <= 1);
        if (!field.getChildren().isEmpty()) {
            this.childSchema = MetadataUtils.fromField(field.getChildren().iterator().next());
            Preconditions.checkArgument(this.childSchema.isArray());
        }
    }

    public RepeatedListColumnMetadata(String name, ColumnMetadata childSchema) {
        super(name, TypeProtos.MinorType.LIST, TypeProtos.DataMode.REPEATED);
        if (childSchema != null) {
            Preconditions.checkArgument(childSchema.isArray());
        }
        this.childSchema = childSchema;
    }

    public void childSchema(ColumnMetadata childMetadata) {
        Preconditions.checkState(this.childSchema == null);
        Preconditions.checkArgument(childMetadata.isArray());
        this.childSchema = childMetadata;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.MULTI_ARRAY;
    }

    @Override
    public boolean isMultiList() {
        return true;
    }

    @Override
    public MaterializedField schema() {
        MaterializedField field = this.emptySchema();
        if (this.childSchema != null) {
            field.addChild(this.childSchema.schema());
        }
        return field;
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name(), this.majorType());
    }

    @Override
    public ColumnMetadata cloneEmpty() {
        RepeatedListColumnMetadata colMeta = new RepeatedListColumnMetadata(this.name, null);
        colMeta.setProperties(this.properties());
        return colMeta;
    }

    @Override
    public ColumnMetadata copy() {
        return new RepeatedListColumnMetadata(this.name, this.childSchema);
    }

    @Override
    public ColumnMetadata childSchema() {
        return this.childSchema;
    }

    @Override
    public int dimensions() {
        return this.childSchema == null ? -1 : this.childSchema.dimensions() + 1;
    }

    @Override
    public String typeString() {
        return "ARRAY<" + this.childSchema.typeString() + ">";
    }

    @Override
    protected void appendContents(StringBuilder buf) {
        buf.append(", child: ").append(this.childSchema().toString());
    }

    @Override
    public boolean isEquivalent(ColumnMetadata o) {
        if (!super.isEquivalent(o)) {
            return false;
        }
        RepeatedListColumnMetadata other = (RepeatedListColumnMetadata)o;
        return this.childSchema.isEquivalent(other.childSchema);
    }
}

