/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnBuilder;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.DynamicColumn;
import org.apache.drill.exec.record.metadata.MapColumnMetadata;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.RepeatedListColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantSchema;

public class MetadataUtils {
    public static TupleSchema fromFields(Iterable<MaterializedField> fields) {
        TupleSchema tuple = new TupleSchema();
        for (MaterializedField field : fields) {
            tuple.add(field);
        }
        return tuple;
    }

    public static ColumnMetadata fromField(MaterializedField field) {
        TypeProtos.MajorType majorType = field.getType();
        TypeProtos.MinorType type = majorType.getMinorType();
        switch (type) {
            case DICT: {
                return MetadataUtils.newDict(field);
            }
            case MAP: {
                return MetadataUtils.newMap(field);
            }
            case UNION: {
                if (field.getType().getMode() != TypeProtos.DataMode.OPTIONAL) {
                    throw new UnsupportedOperationException(type.name() + " type must be nullable");
                }
                return new VariantColumnMetadata(field);
            }
            case VARDECIMAL: {
                int precision = majorType.hasPrecision() ? majorType.getPrecision() : Types.maxPrecision(type);
                int scale = majorType.hasScale() ? majorType.getScale() : 0;
                return MetadataUtils.newDecimal(field.getName(), type, majorType.getMode(), precision, scale);
            }
            case LIST: {
                switch (field.getType().getMode()) {
                    case OPTIONAL: {
                        return new VariantColumnMetadata(field);
                    }
                    case REPEATED: {
                        return new RepeatedListColumnMetadata(field);
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported mode %s for type %s", field.getType().getMode().name(), type.name()));
            }
        }
        return new PrimitiveColumnMetadata(field);
    }

    public static ColumnMetadata fromView(MaterializedField field) {
        if (field.getType().getMinorType() == TypeProtos.MinorType.MAP) {
            return new MapColumnMetadata(field, null);
        }
        if (field.getType().getMinorType() == TypeProtos.MinorType.DICT) {
            return MetadataUtils.newDict(field);
        }
        return new PrimitiveColumnMetadata(field);
    }

    public static TupleSchema fromColumns(List<ColumnMetadata> columns) {
        TupleSchema tuple = new TupleSchema();
        for (ColumnMetadata column : columns) {
            tuple.add(column);
        }
        return tuple;
    }

    public static MapColumnMetadata newMap(MaterializedField field, TupleSchema schema) {
        return new MapColumnMetadata(field, schema);
    }

    public static MapColumnMetadata newMap(MaterializedField field) {
        return new MapColumnMetadata(field, MetadataUtils.fromFields(field.getChildren()));
    }

    public static MapColumnMetadata newMap(String name, TupleMetadata schema) {
        return MetadataUtils.newMap(name, TypeProtos.DataMode.REQUIRED, schema);
    }

    public static MapColumnMetadata newMap(String name) {
        return MetadataUtils.newMap(name, (TupleMetadata)new TupleSchema());
    }

    public static DictColumnMetadata newDict(MaterializedField field) {
        return new DictColumnMetadata(field, MetadataUtils.fromFields(field.getChildren()));
    }

    public static DictColumnMetadata newDict(MaterializedField field, TupleSchema schema) {
        MetadataUtils.validateDictChildren(schema.toFieldList());
        return new DictColumnMetadata(field.getName(), field.getDataMode(), schema);
    }

    private static void validateDictChildren(List<MaterializedField> entryFields) {
        Collection children = entryFields.stream().map(MaterializedField::getName).collect(Collectors.toList());
        String message = "DICT does not contain %s.";
        if (!children.contains("key")) {
            throw new IllegalStateException(String.format(message, "key"));
        }
        if (!children.contains("value")) {
            throw new IllegalStateException(String.format(message, "value"));
        }
    }

    public static DictColumnMetadata newDict(String name) {
        return new DictColumnMetadata(name, TypeProtos.DataMode.REQUIRED);
    }

    public static VariantColumnMetadata newVariant(MaterializedField field, VariantSchema schema) {
        return VariantColumnMetadata.unionOf(field, schema);
    }

    public static VariantColumnMetadata newVariant(String name, TypeProtos.DataMode cardinality) {
        switch (cardinality) {
            case OPTIONAL: {
                return VariantColumnMetadata.union(name);
            }
            case REPEATED: {
                return VariantColumnMetadata.list(name);
            }
        }
        throw new IllegalArgumentException();
    }

    public static RepeatedListColumnMetadata newRepeatedList(String name, ColumnMetadata child) {
        return new RepeatedListColumnMetadata(name, child);
    }

    public static ColumnMetadata newMapArray(String name, TupleMetadata schema) {
        return MetadataUtils.newMap(name, TypeProtos.DataMode.REPEATED, schema);
    }

    public static MapColumnMetadata newMap(String name, TypeProtos.DataMode dataMode, TupleMetadata schema) {
        return new MapColumnMetadata(name, dataMode, (TupleSchema)schema);
    }

    public static ColumnMetadata newMapArray(String name) {
        return MetadataUtils.newMapArray(name, new TupleSchema());
    }

    public static DictColumnMetadata newDictArray(String name) {
        return new DictColumnMetadata(name, TypeProtos.DataMode.REPEATED);
    }

    public static PrimitiveColumnMetadata newScalar(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return MetadataUtils.newScalar(name, type, mode, false);
    }

    public static PrimitiveColumnMetadata newScalar(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, boolean schemaForUnknown) {
        assert (MetadataUtils.isScalar(type));
        return new PrimitiveColumnMetadata(name, type, mode, schemaForUnknown);
    }

    public static PrimitiveColumnMetadata newScalar(String name, TypeProtos.MajorType type) {
        TypeProtos.MinorType minorType = type.getMinorType();
        assert (MetadataUtils.isScalar(minorType));
        return new PrimitiveColumnMetadata(name, type);
    }

    public static ColumnMetadata newDecimal(String name, TypeProtos.DataMode mode, int precision, int scale) {
        return MetadataUtils.newDecimal(name, TypeProtos.MinorType.VARDECIMAL, mode, precision, scale);
    }

    public static ColumnMetadata newDecimal(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        if (precision < 0) {
            throw new IllegalArgumentException("Precision cannot be negative : " + precision);
        }
        if (scale < 0) {
            throw new IllegalArgumentException("Scale cannot be negative : " + scale);
        }
        int maxPrecision = Types.maxPrecision(type);
        if (precision > maxPrecision) {
            throw new IllegalArgumentException(String.format("%s(%d, %d) exceeds maximum suppored precision of %d", type, precision, scale, maxPrecision));
        }
        if (scale > precision) {
            throw new IllegalArgumentException(String.format("%s(%d, %d) scale exceeds precision", type, precision, scale));
        }
        MaterializedField field = new ColumnBuilder(name, type).setMode(mode).setPrecisionAndScale(precision, scale).build();
        return new PrimitiveColumnMetadata(field);
    }

    public static boolean isScalar(ColumnMetadata col) {
        return MetadataUtils.isScalar(col.type());
    }

    public static boolean isScalar(TypeProtos.MinorType type) {
        return !MetadataUtils.isComplex(type);
    }

    public static boolean isComplex(TypeProtos.MinorType type) {
        switch (type) {
            case DICT: 
            case MAP: 
            case UNION: 
            case LIST: {
                return true;
            }
        }
        return false;
    }

    public static ColumnMetadata newDynamic(String name) {
        return new DynamicColumn(name);
    }

    public static ColumnMetadata wildcard() {
        return DynamicColumn.WILDCARD_COLUMN;
    }

    public static boolean isWildcard(ColumnMetadata col) {
        return col.isDynamic() && col.name().equals("**");
    }

    public static ColumnMetadata cloneMapWithSchema(ColumnMetadata source, TupleMetadata members) {
        return MetadataUtils.newMap(source.name(), source.mode(), members);
    }

    public static ColumnMetadata diffMap(ColumnMetadata map, ColumnMetadata other) {
        TupleMetadata diff = MetadataUtils.diffTuple(map.tupleSchema(), other.tupleSchema());
        if (!diff.isEmpty()) {
            return MetadataUtils.cloneMapWithSchema(map, diff);
        }
        return null;
    }

    public static TupleMetadata diffTuple(TupleMetadata base, TupleMetadata subtend) {
        TupleSchema diff = new TupleSchema();
        for (ColumnMetadata col : base) {
            ColumnMetadata mapDiff;
            ColumnMetadata other = subtend.metadata(col.name());
            if (other == null) {
                diff.addColumn(col);
                continue;
            }
            if (!col.isMap() || (mapDiff = MetadataUtils.diffMap(col, other)) == null) continue;
            diff.addColumn(mapDiff);
        }
        return diff;
    }

    public static boolean hasDynamicColumns(TupleMetadata schema) {
        for (ColumnMetadata col : schema) {
            if (!col.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static boolean isRepeatedList(ColumnMetadata col) {
        return col.type() == TypeProtos.MinorType.LIST && col.mode() == TypeProtos.DataMode.REPEATED;
    }
}

