/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.metadata.ColumnBuilder;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.MapBuilder;
import org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.SchemaContainer;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.UnionBuilder;
import org.apache.drill.exec.vector.complex.DictVector;

public class DictBuilder
implements SchemaContainer {
    private final TupleSchema schema = new TupleSchema();
    private final SchemaContainer parent;
    private final String name;
    private final TypeProtos.DataMode mode;

    public DictBuilder(SchemaContainer parent, String name, TypeProtos.DataMode mode) {
        this.parent = parent;
        this.name = name;
        this.mode = mode;
    }

    @Override
    public void addColumn(ColumnMetadata column) {
        if (!"value".equals(column.name())) {
            String message = String.format("Expected column with name '%s'. Found: '%s'.", "value", column.name());
            throw new IllegalArgumentException(message);
        }
        if (this.isFieldSet(column.name())) {
            String message = String.format("Field '%s' is already defined in dict.", column.name());
            throw new IllegalArgumentException(message);
        }
        this.schema.addColumn(column);
    }

    public DictBuilder key(TypeProtos.MinorType type) {
        TypeProtos.MajorType keyType = Types.withMode(type, TypeProtos.DataMode.REQUIRED);
        return this.key(keyType);
    }

    public DictBuilder key(TypeProtos.MajorType type) {
        String fieldName = "key";
        if (this.isFieldSet("key")) {
            throw new IllegalStateException(String.format("Filed '%s' is already defined.", "key"));
        }
        if (!this.isSupportedKeyType(type)) {
            throw new IllegalArgumentException(String.format("'%s' in dict should be non-nullable primitive. Found: %s", "key", type));
        }
        this.addField("key", type);
        return this;
    }

    private boolean isFieldSet(String name) {
        return this.schema.index(name) != -1;
    }

    public DictBuilder value(TypeProtos.MinorType type) {
        return this.value(type, TypeProtos.DataMode.REQUIRED);
    }

    public DictBuilder nullableValue(TypeProtos.MinorType type) {
        return this.value(type, TypeProtos.DataMode.OPTIONAL);
    }

    public DictBuilder repeatedValue(TypeProtos.MinorType type) {
        return this.value(type, TypeProtos.DataMode.REPEATED);
    }

    private DictBuilder value(TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        TypeProtos.MajorType valueType = Types.withMode(type, mode);
        return this.value(valueType);
    }

    public DictBuilder value(TypeProtos.MajorType type) {
        String fieldName = "value";
        if (this.isFieldSet("value")) {
            throw new IllegalStateException(String.format("Field '%s' is already defined.", "value"));
        }
        if (Types.isComplex(type) || Types.isUnion(type)) {
            String msg = String.format("Complex type found %s when defining '%s'. Use mapValue(), listValue() etc. in case of complex value type.", "value", type);
            throw new IllegalArgumentException(msg);
        }
        this.addField("value", type);
        return this;
    }

    private void addField(String name, TypeProtos.MajorType type) {
        ColumnBuilder builder = new ColumnBuilder(name, type.getMinorType()).setMode(type.getMode());
        if (type.hasScale()) {
            builder.setPrecisionAndScale(type.getPrecision(), type.getScale());
        } else if (type.hasPrecision()) {
            builder.setPrecision(type.getPrecision());
        }
        if (type.hasWidth()) {
            builder.setWidth(type.getWidth());
        }
        if (Types.isRepeated(type)) {
            this.schema.add(SchemaBuilder.columnSchema(name, type.getMinorType(), type.getMode()));
            return;
        }
        this.schema.add(builder.build());
    }

    public MapBuilder mapValue() {
        return new MapBuilder(this, "value", TypeProtos.DataMode.REQUIRED);
    }

    public MapBuilder mapArrayValue() {
        return new MapBuilder(this, "value", TypeProtos.DataMode.REPEATED);
    }

    public DictBuilder dictValue() {
        return new DictBuilder(this, "value", TypeProtos.DataMode.REQUIRED);
    }

    public DictBuilder dictArrayValue() {
        return new DictBuilder(this, "value", TypeProtos.DataMode.REPEATED);
    }

    public UnionBuilder unionValue() {
        return new UnionBuilder(this, "value", TypeProtos.MinorType.UNION);
    }

    public UnionBuilder listValue() {
        return new UnionBuilder(this, "value", TypeProtos.MinorType.LIST);
    }

    public RepeatedListBuilder repeatedListValue() {
        return new RepeatedListBuilder(this, "value");
    }

    public DictColumnMetadata buildColumn() {
        this.validateKeyValuePresent();
        return new DictColumnMetadata(this.name, this.mode, this.schema);
    }

    private void validateKeyValuePresent() {
        for (String fieldName : DictVector.fieldNames) {
            ColumnMetadata columnMetadata = this.schema.metadata(fieldName);
            if (columnMetadata != null) continue;
            throw new IllegalStateException(String.format("Field %s is absent in DICT.", fieldName));
        }
    }

    public void build() {
        if (this.parent != null) {
            this.parent.addColumn(this.buildColumn());
        }
    }

    public SchemaBuilder resumeSchema() {
        this.build();
        return (SchemaBuilder)this.parent;
    }

    public MapBuilder resumeMap() {
        this.build();
        return (MapBuilder)this.parent;
    }

    public RepeatedListBuilder resumeList() {
        this.build();
        return (RepeatedListBuilder)this.parent;
    }

    public UnionBuilder resumeUnion() {
        this.build();
        return (UnionBuilder)this.parent;
    }

    public DictBuilder resumeDict() {
        this.build();
        return (DictBuilder)this.parent;
    }

    private boolean isSupportedKeyType(TypeProtos.MajorType type) {
        return !Types.isComplex(type) && !Types.isUnion(type) && type.getMode() == TypeProtos.DataMode.REQUIRED;
    }
}

