/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.MaterializedField;

public class ColumnBuilder {
    private final String name;
    private final TypeProtos.MajorType.Builder typeBuilder;

    public ColumnBuilder(String name, TypeProtos.MinorType type) {
        this.name = name;
        this.typeBuilder = TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(TypeProtos.DataMode.REQUIRED);
    }

    public ColumnBuilder setMode(TypeProtos.DataMode mode) {
        this.typeBuilder.setMode(mode);
        return this;
    }

    public ColumnBuilder setWidth(int width) {
        return this.setPrecision(width);
    }

    public ColumnBuilder setPrecision(int precision) {
        if (precision != 0) {
            this.typeBuilder.setPrecision(precision);
        }
        return this;
    }

    public ColumnBuilder setPrecisionAndScale(int precision, int scale) {
        if (precision != 0) {
            this.typeBuilder.setPrecision(precision);
            this.typeBuilder.setScale(scale);
        }
        return this;
    }

    public MaterializedField build() {
        return MaterializedField.create(this.name, this.typeBuilder.build());
    }
}

