/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class SchemaBuilder {
    private List<MaterializedField> fields = Lists.newArrayList();
    private BatchSchema.SelectionVectorMode selectionVectorMode = BatchSchema.SelectionVectorMode.NONE;

    SchemaBuilder() {
    }

    public SchemaBuilder setSelectionVectorMode(BatchSchema.SelectionVectorMode selectionVectorMode) {
        this.selectionVectorMode = selectionVectorMode;
        return this;
    }

    public SchemaBuilder addFields(Iterable<MaterializedField> fields) {
        for (MaterializedField f : fields) {
            this.addField(f);
        }
        return this;
    }

    public SchemaBuilder addSerializedFields(Iterable<UserBitShared.SerializedField> fields) {
        for (UserBitShared.SerializedField f : fields) {
            this.addField(MaterializedField.create(f));
        }
        return this;
    }

    public SchemaBuilder addField(MaterializedField f) {
        this.fields.add(f);
        return this;
    }

    public SchemaBuilder removeField(MaterializedField f) throws SchemaChangeException {
        if (!this.fields.remove(f)) {
            throw new SchemaChangeException("You attempted to remove an nonexistent field.");
        }
        return this;
    }

    public BatchSchema build() {
        ArrayList<MaterializedField> fieldList = Lists.newArrayList(this.fields);
        return new BatchSchema(this.selectionVectorMode, fieldList);
    }
}

