/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.vector.SchemaChangeCallBack;

public abstract class AbstractUnaryRecordBatch<T extends PhysicalOperator>
extends AbstractRecordBatch<T> {
    protected SchemaChangeCallBack callBack = new SchemaChangeCallBack();
    private RecordBatch.IterOutcome lastKnownOutcome;

    public AbstractUnaryRecordBatch(T popConfig, FragmentContext context) throws OutOfMemoryException {
        super(popConfig, context, false);
    }

    protected abstract RecordBatch getIncoming();

    @Override
    protected void cancelIncoming() {
        this.getIncoming().cancel();
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        RecordBatch incoming = this.getIncoming();
        if (this.state == AbstractRecordBatch.BatchState.DONE) {
            return RecordBatch.IterOutcome.NONE;
        }
        RecordBatch.IterOutcome upstream = this.next(incoming);
        if (this.state != AbstractRecordBatch.BatchState.FIRST && upstream == RecordBatch.IterOutcome.OK && incoming.getRecordCount() == 0) {
            do {
                incoming.getContainer().zeroVectors();
            } while ((upstream = this.next(incoming)) == RecordBatch.IterOutcome.OK && incoming.getRecordCount() == 0);
        }
        if (this.state == AbstractRecordBatch.BatchState.FIRST) {
            if (upstream == RecordBatch.IterOutcome.OK) {
                upstream = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
            } else if (upstream == RecordBatch.IterOutcome.EMIT) {
                throw new IllegalStateException("Received first batch with unexpected EMIT IterOutcome");
            }
        }
        this.lastKnownOutcome = upstream;
        switch (upstream) {
            case NONE: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    return this.handleNullInput();
                }
                return upstream;
            }
            case NOT_YET: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
                }
                return upstream;
            }
            case OK_NEW_SCHEMA: {
                if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                    this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
                }
                try {
                    this.stats.startSetup();
                    if (!this.setupNewSchema()) {
                        upstream = RecordBatch.IterOutcome.OK;
                    }
                }
                finally {
                    this.stats.stopSetup();
                }
            }
            case OK: 
            case EMIT: {
                assert (this.state != AbstractRecordBatch.BatchState.FIRST) : "First batch should be OK_NEW_SCHEMA";
                this.container.zeroVectors();
                RecordBatch.IterOutcome out = this.doWork();
                if (out != RecordBatch.IterOutcome.OK) {
                    upstream = out;
                }
                if (this.callBack.getSchemaChangedAndReset()) {
                    return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                }
                return upstream;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected abstract boolean setupNewSchema();

    protected abstract RecordBatch.IterOutcome doWork();

    protected RecordBatch.IterOutcome handleNullInput() {
        this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        this.container.setEmpty();
        return RecordBatch.IterOutcome.NONE;
    }

    protected RecordBatch.IterOutcome getLastKnownOutcome() {
        return this.lastKnownOutcome;
    }

    protected void setLastKnownOutcome(RecordBatch.IterOutcome outcome) {
        this.lastKnownOutcome = outcome;
    }
}

