/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types.decimal;

import org.apache.drill.exec.planner.types.DrillRelDataTypeSystem;
import org.apache.drill.exec.planner.types.decimal.DrillBaseComputeScalePrecision;

public class DecimalScalePrecisionModFunction
extends DrillBaseComputeScalePrecision {
    public DecimalScalePrecisionModFunction(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        super(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    @Override
    public void computeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        this.outputScale = Math.max(leftScale, rightScale);
        int leftIntegerDigits = leftPrecision - leftScale;
        this.outputPrecision = DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
        if (this.outputScale + leftIntegerDigits > this.outputPrecision) {
            this.outputScale = this.outputPrecision - leftIntegerDigits;
        }
        this.outputPrecision = Math.min(this.outputPrecision, Math.max(leftPrecision, rightPrecision));
    }
}

