/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public abstract class AbstractRelDataTypeHolder {
    protected final List<RelDataTypeField> fields;
    protected RelDataTypeFactory typeFactory;

    public AbstractRelDataTypeHolder(List<RelDataTypeField> fields) {
        this.fields = Lists.newArrayList(fields);
    }

    public abstract RelDataTypeField getField(RelDataTypeFactory var1, String var2);

    public List<RelDataTypeField> getFieldList(RelDataTypeFactory typeFactory) {
        return ImmutableList.copyOf(this.fields);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public List<String> getFieldNames() {
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (RelDataTypeField f : this.fields) {
            fieldNames.add(f.getName());
        }
        return fieldNames;
    }

    public void setRelDataTypeFactory(RelDataTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }
}

